/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class FisherTest
implements BivariateFloatListFunction {
    private int[][] table = new int[2][2];

    @Override
    public float evaluate(FloatList list1, FloatList list2) {
        this.table[0][0] = 0;
        this.table[0][1] = 0;
        this.table[1][0] = 0;
        this.table[1][1] = 0;
        int ncols = list1.size();
        for (int j = 0; j < ncols; ++j) {
            float v1 = list1.getValue(j);
            float v2 = list2.getValue(j);
            if (v1 == 0.0f) {
                int[] nArray = this.table[v2 == 0.0f ? 1 : 0];
                nArray[1] = nArray[1] + 1;
                continue;
            }
            if (v1 != 1.0f) continue;
            int[] nArray = this.table[v2 == 0.0f ? 1 : 0];
            nArray[0] = nArray[0] + 1;
        }
        int populationSize = this.table[0][0] + this.table[0][1] + this.table[1][0] + this.table[1][1];
        int numberOfSuccesses = this.table[0][0] + this.table[0][1];
        int x = this.table[0][0];
        int sampleSize = this.table[0][0] + this.table[1][0];
        HypergeometricDistribution dist = new HypergeometricDistribution(populationSize, numberOfSuccesses, sampleSize);
        float upper = (float)dist.upperCumulativeProbability(x);
        float lower = (float)dist.cumulativeProbability(x);
        return lower < upper ? -lower : upper;
    }

    public String toString() {
        return "Fishers Exact Test";
    }
}

