/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public abstract class AbstractVector
implements Vector {
    private Class<?> columnClass;
    private Comparator<Object> comparator;
    private String name;
    private Map<Object, Object> properties = new HashMap<Object, Object>();

    public AbstractVector(String columnName, Class<?> c) {
        this.name = columnName;
        this.columnClass = c;
        this.comparator = VectorUtil.getDefaultComparator(this.columnClass);
    }

    @Override
    public Class<?> getColumnClass() {
        return this.columnClass;
    }

    @Override
    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public void removeProperty(Object key) {
        this.properties.remove(key);
    }

    @Override
    public void setColumnClass(Class<?> c) {
        this.columnClass = c;
        this.comparator = null;
        this.comparator = VectorUtil.getDefaultComparator(this.columnClass);
    }

    @Override
    public void setComparator(Comparator<Object> comparator) {
        if (comparator == null) {
            comparator = VectorUtil.getDefaultComparator(this.columnClass);
        }
        this.comparator = comparator;
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
        if ("Chart Style".equals(key) && !this.properties.containsKey("Chart Color Enabled")) {
            this.properties.put("Chart Color Enabled", true);
        }
    }

    public String toString() {
        return this.name;
    }
}

