/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.Collection;
import java.util.Comparator;
import org.broadinstitute.genee.matrix.CombinedVector;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class CombinedRowsDatasetView
implements Dataset {
    private Dataset addOnDataset;
    private Dataset primaryDataset;
    private String idVectorName;

    public CombinedRowsDatasetView(Dataset primaryDataset, Dataset addOnDataset) {
        Vector v = MetadataUtil.getByIName(primaryDataset.getRowMetadata(), "id");
        if (v == null) {
            this.idVectorName = "id";
            MetadataUtil.addRowVector(primaryDataset.getRowMetadata(), "id", String.class);
        } else {
            this.idVectorName = v.getName();
        }
        this.primaryDataset = primaryDataset;
        this.addOnDataset = addOnDataset;
    }

    public Dataset getAddOnDataset() {
        return this.addOnDataset;
    }

    @Override
    public int getColumnCount() {
        return this.primaryDataset.getColumnCount();
    }

    @Override
    public MetadataModel getColumnMetadata() {
        return this.primaryDataset.getColumnMetadata();
    }

    @Override
    public String getName() {
        return this.primaryDataset.getName();
    }

    @Override
    public Object getObjectValue(int rowIndex, int columnIndex, int seriesIndex) {
        if (rowIndex < this.addOnDataset.getRowCount()) {
            return this.addOnDataset.getObjectValue(rowIndex, columnIndex, seriesIndex);
        }
        return this.primaryDataset.getObjectValue(rowIndex - this.addOnDataset.getRowCount(), columnIndex, seriesIndex);
    }

    public Dataset getPrimaryDataset() {
        return this.primaryDataset;
    }

    @Override
    public Object getProperty(Object key) {
        return this.primaryDataset.getProperty(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.primaryDataset.getPropertyKeys();
    }

    @Override
    public int getRowCount() {
        return this.primaryDataset.getRowCount() + this.addOnDataset.getRowCount();
    }

    @Override
    public MetadataModel getRowMetadata() {
        return new MetadataModelAddOn(this.primaryDataset.getRowMetadata());
    }

    @Override
    public Class<?> getSeriesClass(int series) {
        return this.primaryDataset.getSeriesClass(series);
    }

    @Override
    public int getSeriesCount() {
        return this.primaryDataset.getSeriesCount();
    }

    @Override
    public String getSeriesName(int series) {
        return this.primaryDataset.getSeriesName(series);
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        if (rowIndex < this.addOnDataset.getRowCount()) {
            return this.addOnDataset.getValue(rowIndex, columnIndex);
        }
        return this.primaryDataset.getValue(rowIndex - this.addOnDataset.getRowCount(), columnIndex);
    }

    @Override
    public float getValue(int rowIndex, int columnIndex, int seriesIndex) {
        if (rowIndex < this.addOnDataset.getRowCount()) {
            return this.addOnDataset.getValue(rowIndex, columnIndex, seriesIndex);
        }
        return this.primaryDataset.getValue(rowIndex - this.addOnDataset.getRowCount(), columnIndex, seriesIndex);
    }

    public void setAddOnDataset(Dataset addOnDataset) {
        this.addOnDataset = addOnDataset;
    }

    @Override
    public void setName(String name) {
        this.primaryDataset.setName(name);
    }

    public void setPrimaryDataset(Dataset primaryDataset) {
        this.primaryDataset = primaryDataset;
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.primaryDataset.setProperty(key, value);
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, float value) {
        if (rowIndex < this.addOnDataset.getRowCount()) {
            this.addOnDataset.setValue(rowIndex, columnIndex, value);
        } else {
            this.primaryDataset.setValue(rowIndex - this.addOnDataset.getRowCount(), columnIndex, value);
        }
    }

    private class VectorAddOn
    implements Vector {
        private Vector vector;

        public VectorAddOn(Vector vector) {
            this.vector = vector;
        }

        @Override
        public Class<?> getColumnClass() {
            return this.vector.getColumnClass();
        }

        @Override
        public Comparator<Object> getComparator() {
            return this.vector.getComparator();
        }

        @Override
        public String getName() {
            return this.vector.getName();
        }

        @Override
        public Object getProperty(Object key) {
            return this.vector.getProperty(key);
        }

        @Override
        public Collection<Object> getPropertyKeys() {
            return this.vector.getPropertyKeys();
        }

        @Override
        public Object getValue(int index) {
            return index < CombinedRowsDatasetView.this.addOnDataset.getRowCount() ? null : this.vector.getValue(index - CombinedRowsDatasetView.this.addOnDataset.getRowCount());
        }

        @Override
        public void removeProperty(Object key) {
            this.vector.removeProperty(key);
        }

        @Override
        public void setColumnClass(Class<?> columnClass) {
            this.vector.setColumnClass(columnClass);
        }

        @Override
        public void setComparator(Comparator<Object> comparator) {
            this.vector.setComparator(comparator);
        }

        @Override
        public void setProperty(Object key, Object value) {
            this.vector.setProperty(key, value);
        }

        @Override
        public void setValue(int index, Object value) {
            if (index >= CombinedRowsDatasetView.this.addOnDataset.getRowCount()) {
                this.vector.setValue(index - CombinedRowsDatasetView.this.addOnDataset.getRowCount(), value);
            }
        }

        @Override
        public int size() {
            return this.vector.size() + CombinedRowsDatasetView.this.addOnDataset.getRowCount();
        }
    }

    private class MetadataModelAddOn
    implements MetadataModel {
        private MetadataModel model;

        public MetadataModelAddOn(MetadataModel model) {
            this.model = model;
        }

        @Override
        public Vector add(String columnName, Class<?> columnClass) {
            return this.model.add(columnName, columnClass);
        }

        @Override
        public Vector get(int metadataIndex) {
            Vector v = this.model.get(metadataIndex);
            if (CombinedRowsDatasetView.this.idVectorName.equals(v.getName())) {
                return new CombinedVector(CombinedRowsDatasetView.this.addOnDataset.getRowMetadata().get(0), v);
            }
            return new VectorAddOn(v);
        }

        @Override
        public Vector get(String name) {
            int index = this.model.getColumnIndex(name);
            return index != -1 ? this.get(index) : null;
        }

        @Override
        public int getColumnIndex(String columnName) {
            return this.model.getColumnIndex(columnName);
        }

        @Override
        public String getColumnName(int metadataIndex) {
            return this.model.getColumnName(metadataIndex);
        }

        @Override
        public int getItemCount() {
            return this.model.getItemCount() + CombinedRowsDatasetView.this.addOnDataset.getRowCount();
        }

        @Override
        public int getMetadataCount() {
            return this.model.getMetadataCount();
        }

        @Override
        public Object getValue(int itemIndex, int metadataIndex) {
            return this.get(metadataIndex).getValue(itemIndex);
        }

        @Override
        public Object getValue(int itemIndex, String columnName) {
            Vector v = this.get(columnName);
            return v != null ? v.getValue(itemIndex) : null;
        }

        @Override
        public void remove(int metadataIndex) {
            this.model.remove(metadataIndex);
        }

        @Override
        public void setValue(int itemIndex, int metadataIndex, Object aValue) {
            this.get(metadataIndex).setValue(itemIndex, aValue);
        }

        @Override
        public void setValue(int itemIndex, String columnName, Object aValue) {
            Vector v = this.get(columnName);
            if (v != null) {
                v.setValue(itemIndex, aValue);
            }
        }
    }
}

