/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Comparators {
    private static final StringCaseInsensitiveComparator STRING_CASE_INSENSITIVE_ORDER = new StringCaseInsensitiveComparator();

    private Comparators() {
    }

    public static int compareToHandleNull(Object c1, Object c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return 2;
    }

    public static StringCaseInsensitiveComparator getStringCaseInsensitiveOrder() {
        return STRING_CASE_INSENSITIVE_ORDER;
    }

    public static class StringCaseInsensitiveComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            int value = Comparators.compareToHandleNull(o1, o2);
            return value == 2 ? String.CASE_INSENSITIVE_ORDER.compare(o1, o2) : value;
        }
    }

    public static class ObjectComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            String s2;
            String s1 = String.valueOf(o1);
            int value = Comparators.compareToHandleNull(s1, s2 = String.valueOf(o2));
            return value == 2 ? String.CASE_INSENSITIVE_ORDER.compare(s1, s2) : value;
        }
    }

    public static class DescendingComparator<T extends Comparable>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            int value = Comparators.compareToHandleNull(o2, o1);
            return value == 2 ? o2.compareTo(o1) : value;
        }
    }

    public static class CustomSortOrderComparator
    implements Comparator {
        private Map<Object, Integer> valueToSortOrder = new HashMap<Object, Integer>();

        public CustomSortOrderComparator(Collection<?> list) {
            int i = 0;
            for (Object obj : list) {
                this.valueToSortOrder.put(obj, i++);
            }
        }

        public int compare(Object o1, Object o2) {
            int _v2;
            Integer v1 = this.valueToSortOrder.get(o1);
            int _v1 = v1 != null ? v1 : Integer.MAX_VALUE;
            Integer v2 = this.valueToSortOrder.get(o2);
            int n = _v2 = v2 != null ? v2 : Integer.MAX_VALUE;
            return _v1 < _v2 ? -1 : (_v1 == _v2 ? 0 : 1);
        }
    }

    public static class ComparatorList
    implements Comparator<List<Object>> {
        private Comparator[] array;

        public ComparatorList(Comparator[] array) {
            this.array = array;
        }

        @Override
        public int compare(List<Object> list1, List<Object> list2) {
            int length = this.array.length;
            for (int i = 0; i < length; ++i) {
                Object o1 = list1.get(i);
                Object o2 = list2.get(i);
                int result = o1 == null ? (o2 == null ? 0 : 1) : this.array[i].compare(o1, o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    public static class AscendingComparator<T extends Comparable>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            int value = Comparators.compareToHandleNull(o1, o2);
            return value == 2 ? o1.compareTo(o2) : value;
        }
    }
}

