/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapter;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public class DatasetWithVectors
extends DatasetAdapter {
    private MetadataModel rowMetadata;
    private List<Vector> vectors;

    public DatasetWithVectors(Dataset dataset, List<Vector> vectors) {
        super(dataset);
        this.vectors = vectors;
        this.rowMetadata = new MyMetadataModel(this.rowMetadata, vectors.size());
    }

    @Override
    public Object getObjectValue(int rowIndex, int columnIndex, int seriesIndex) {
        if (seriesIndex == 0) {
            return Float.valueOf(this.getValue(rowIndex, columnIndex));
        }
        return rowIndex < this.vectors.size() ? Float.valueOf(Float.NaN) : this.dataset.getObjectValue(rowIndex - this.vectors.size(), columnIndex, seriesIndex);
    }

    @Override
    public int getRowCount() {
        return this.vectors.size() + this.dataset.getRowCount();
    }

    @Override
    public MetadataModel getRowMetadata() {
        return this.rowMetadata;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        return rowIndex < this.vectors.size() ? this.getVectorValue(rowIndex, columnIndex) : this.dataset.getValue(rowIndex - this.vectors.size(), columnIndex);
    }

    @Override
    public float getValue(int rowIndex, int columnIndex, int seriesIndex) {
        if (seriesIndex == 0) {
            return this.getValue(rowIndex, columnIndex);
        }
        return rowIndex < this.vectors.size() ? Float.NaN : this.dataset.getValue(rowIndex - this.vectors.size(), columnIndex);
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, float value) {
        if (rowIndex < this.vectors.size()) {
            this.vectors.get(rowIndex).setValue(columnIndex, Float.valueOf(value));
        } else {
            this.dataset.setValue(rowIndex - this.vectors.size(), columnIndex, value);
        }
    }

    private float getVectorValue(int rowIndex, int columnIndex) {
        Number number = (Number)this.vectors.get(rowIndex).getValue(columnIndex);
        return number == null ? Float.NaN : number.floatValue();
    }

    private static class VectorWithNulls
    implements Vector {
        private Object[] values;
        private Vector vector;

        private VectorWithNulls(Vector vector, int nNulls) {
            this.vector = vector;
            this.values = new Object[nNulls];
        }

        @Override
        public Class<?> getColumnClass() {
            return this.vector.getColumnClass();
        }

        @Override
        public Comparator<Object> getComparator() {
            return this.vector.getComparator();
        }

        @Override
        public String getName() {
            return this.vector.getName();
        }

        @Override
        public Object getProperty(Object key) {
            return this.vector.getProperty(key);
        }

        @Override
        public Collection<Object> getPropertyKeys() {
            return this.vector.getPropertyKeys();
        }

        @Override
        public Object getValue(int index) {
            return index < this.values.length ? this.values[index] : this.vector.getValue(index - this.values.length);
        }

        @Override
        public void removeProperty(Object key) {
            this.vector.removeProperty(key);
        }

        @Override
        public void setColumnClass(Class<?> columnClass) {
            this.vector.setColumnClass(columnClass);
        }

        @Override
        public void setComparator(Comparator<Object> comparator) {
            this.vector.setComparator(comparator);
        }

        @Override
        public void setProperty(Object key, Object value) {
            this.vector.setProperty(key, value);
        }

        @Override
        public void setValue(int index, Object value) {
            if (index < this.values.length) {
                this.values[index] = value;
            } else {
                this.vector.setValue(index - this.values.length, value);
            }
        }

        @Override
        public int size() {
            return this.values.length + this.vector.size();
        }
    }

    private static class MyMetadataModel
    implements MetadataModel {
        private MetadataModel model;
        private int nNulls;
        private List<VectorWithNulls> vectors = new ArrayList<VectorWithNulls>();

        private MyMetadataModel(MetadataModel model, int nNulls) {
            this.model = model;
            this.nNulls = nNulls;
            int size = model.getMetadataCount();
            for (int i = 0; i < size; ++i) {
                this.vectors.add(new VectorWithNulls(model.get(i), nNulls));
            }
        }

        @Override
        public Vector add(String columnName, Class<?> columnClass) {
            int index = this.model.getColumnIndex(columnName);
            if (index != -1) {
                this.vectors.remove(index);
            }
            VectorWithNulls v = new VectorWithNulls(this.model.add(columnName, columnClass), this.nNulls);
            this.vectors.add(v);
            return v;
        }

        @Override
        public Vector get(int metadataIndex) {
            return this.vectors.get(metadataIndex);
        }

        @Override
        public Vector get(String name) {
            return this.vectors.get(this.model.getColumnIndex(name));
        }

        @Override
        public int getColumnIndex(String columnName) {
            return this.model.getColumnIndex(columnName);
        }

        @Override
        public String getColumnName(int metadataIndex) {
            return this.model.getColumnName(metadataIndex);
        }

        @Override
        public int getItemCount() {
            return this.nNulls + this.model.getItemCount();
        }

        @Override
        public int getMetadataCount() {
            return this.model.getMetadataCount();
        }

        @Override
        public Object getValue(int itemIndex, int metadataIndex) {
            return this.vectors.get(metadataIndex).getValue(itemIndex);
        }

        @Override
        public Object getValue(int itemIndex, String columnName) {
            return this.vectors.get(this.model.getColumnIndex(columnName)).getValue(itemIndex);
        }

        @Override
        public void remove(int metadataIndex) {
            this.vectors.remove(metadataIndex);
            this.model.remove(metadataIndex);
        }

        @Override
        public void setValue(int itemIndex, int metadataIndex, Object aValue) {
            this.vectors.get(metadataIndex).setValue(itemIndex, aValue);
        }

        @Override
        public void setValue(int itemIndex, String columnName, Object aValue) {
            this.vectors.get(this.model.getColumnIndex(columnName)).setValue(itemIndex, aValue);
        }
    }
}

