/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.matrix.ClassVector;

public class DefaultClassVector
implements ClassVector {
    private Map<Integer, List<Integer>> classNumber2IndicesMap;
    private int[] assignments;
    private Map<Integer, String> classNumber2LabelMap;
    private int classCount;
    private String description;

    public DefaultClassVector(Object[] x) {
        this.assignments = new int[x.length];
        this.classNumber2IndicesMap = new HashMap<Integer, List<Integer>>();
        this.classNumber2LabelMap = new HashMap<Integer, String>();
        int maxClassNumber = 0;
        HashMap<String, Integer> className2ClassNumberMap = new HashMap<String, Integer>();
        for (int i = 0; i < x.length; ++i) {
            Integer classNumberInteger = (Integer)className2ClassNumberMap.get(x[i]);
            if (classNumberInteger == null) {
                classNumberInteger = maxClassNumber++;
                String s = String.valueOf(x[i]);
                className2ClassNumberMap.put(s, classNumberInteger);
                this.classNumber2IndicesMap.put(classNumberInteger, new ArrayList());
                this.classNumber2LabelMap.put(classNumberInteger, s);
            }
            this.assignments[i] = classNumberInteger;
            List<Integer> indices = this.classNumber2IndicesMap.get(classNumberInteger);
            indices.add(i);
        }
        this.classCount = maxClassNumber;
    }

    public DefaultClassVector(Object[] x, Object[] classes) {
        Integer classNumberInteger;
        int i;
        this.assignments = new int[x.length];
        this.classNumber2IndicesMap = new HashMap<Integer, List<Integer>>();
        this.classNumber2LabelMap = new HashMap<Integer, String>();
        int maxClassNumber = classes.length;
        HashMap<Object, Integer> className2ClassNumberMap = new HashMap<Object, Integer>();
        for (i = 0; i < classes.length; ++i) {
            classNumberInteger = i;
            className2ClassNumberMap.put(classes[i], classNumberInteger);
            this.classNumber2IndicesMap.put(classNumberInteger, new ArrayList());
            this.classNumber2LabelMap.put(classNumberInteger, String.valueOf(classes[i]));
        }
        for (i = 0; i < x.length; ++i) {
            classNumberInteger = (Integer)className2ClassNumberMap.get(x[i]);
            if (classNumberInteger == null) {
                classNumberInteger = maxClassNumber++;
                className2ClassNumberMap.put(x[i], classNumberInteger);
                this.classNumber2IndicesMap.put(classNumberInteger, new ArrayList());
                this.classNumber2LabelMap.put(classNumberInteger, String.valueOf(x[i]));
            }
            this.assignments[i] = classNumberInteger;
            List<Integer> indices = this.classNumber2IndicesMap.get(classNumberInteger);
            indices.add(i);
        }
        this.classCount = maxClassNumber;
    }

    public DefaultClassVector[] getAllPairs() {
        int n = this.getClassCount();
        ArrayList<DefaultClassVector> list = new ArrayList<DefaultClassVector>();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int k;
                int[] iIndices = this.getIndices(i);
                int[] jIndices = this.getIndices(j);
                Object[] x = new String[iIndices.length + jIndices.length];
                for (k = 0; k < iIndices.length; ++k) {
                    x[k] = this.getClassName(i);
                }
                for (k = 0; k < jIndices.length; ++k) {
                    x[k + iIndices.length] = this.getClassName(j);
                }
                DefaultClassVector pair = new DefaultClassVector(x, new String[]{this.getClassName(i), this.getClassName(j)});
                pair.setDescription(this.getClassName(i) + " vs. " + this.getClassName(j));
                list.add(pair);
            }
        }
        return list.toArray(new DefaultClassVector[0]);
    }

    @Override
    public int getAssignment(int index) {
        return this.assignments[index];
    }

    public int[] getAssignments() {
        return (int[])this.assignments.clone();
    }

    @Override
    public int getClassCount() {
        return this.classCount;
    }

    @Override
    public String getClassName(int classNumber) {
        return this.classNumber2LabelMap.get(classNumber);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public int[] getIndices(int classNumber) {
        List<Integer> indices = this.classNumber2IndicesMap.get(classNumber);
        if (indices == null) {
            return new int[0];
        }
        int[] _indices = new int[indices.size()];
        int length = _indices.length;
        for (int i = 0; i < length; ++i) {
            _indices[i] = indices.get(i);
        }
        return _indices;
    }

    public DefaultClassVector[] getOneVersusAll() {
        int numClasses = this.getClassCount();
        DefaultClassVector[] array = new DefaultClassVector[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            Object[] x = new String[this.size()];
            for (int j = 0; j < x.length; ++j) {
                int assignment = this.getAssignment(j);
                x[j] = assignment == i ? this.getClassName(assignment) : "Rest";
            }
            DefaultClassVector oneVersusAll = new DefaultClassVector(x, new String[]{this.getClassName(i), "Rest"});
            oneVersusAll.setDescription(this.getClassName(i) + " vs. Rest");
            array[i] = oneVersusAll;
        }
        return array;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int size() {
        return this.assignments.length;
    }

    public DefaultClassVector slice(int[] order) {
        return this.slice(order, false);
    }

    public DefaultClassVector slice(int[] order, boolean includeSlicedClassOnly) {
        Object[] x = new String[order.length];
        int length = order.length;
        for (int i = 0; i < length; ++i) {
            x[i] = this.getClassName(this.assignments[order[i]]);
        }
        if (includeSlicedClassOnly) {
            return new DefaultClassVector(x);
        }
        Object[] classes = new String[this.getClassCount()];
        int num = this.getClassCount();
        for (int i = 0; i < num; ++i) {
            classes[i] = this.getClassName(i);
        }
        return new DefaultClassVector(x, classes);
    }

    public String toAssignmentString() {
        StringBuilder sb = new StringBuilder();
        int length = this.assignments.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.assignments[i]);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.assignments.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.getClassName(this.assignments[i]));
        }
        return sb.toString();
    }

    public DefaultClassVector union(DefaultClassVector classVector) {
        int[][] lookup = new int[this.getClassCount()][classVector.getClassCount()];
        int classNumber = 0;
        for (int i = 0; i < this.getClassCount(); ++i) {
            for (int j = 0; j < classVector.getClassCount(); ++j) {
                lookup[i][j] = classNumber++;
            }
        }
        Object[] assignments = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            assignments[i] = "Class " + lookup[this.getAssignment(i)][classVector.getAssignment(i)];
        }
        return new DefaultClassVector(assignments);
    }
}

