/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.Collection;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class MetadataModelAsDatasetView
implements Dataset {
    private MetadataModel model;
    private MetadataModel rowMetadataModel;

    public MetadataModelAsDatasetView(MetadataModel model, MetadataModel datasetMetadataModel) {
        this.model = model;
        this.rowMetadataModel = new DefaultMetadataModel(model.getItemCount());
        Vector origVector = MetadataUtil.getByIName(datasetMetadataModel, "id");
        String name = "id";
        if (origVector != null) {
            name = origVector.getName();
        }
        Vector v = MetadataUtil.addRowVector(this.rowMetadataModel, name, String.class);
        int n = model.getMetadataCount();
        for (int i = 0; i < n; ++i) {
            v.setValue(i, model.getColumnName(i));
        }
    }

    @Override
    public int getColumnCount() {
        return this.model.getItemCount();
    }

    @Override
    public MetadataModel getColumnMetadata() {
        return null;
    }

    public MetadataModel getModel() {
        return this.model;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Object getObjectValue(int rowIndex, int columnIndex, int seriesIndex) {
        return seriesIndex == 0 ? this.model.get(rowIndex).getValue(columnIndex) : null;
    }

    @Override
    public Object getProperty(Object key) {
        return null;
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return null;
    }

    @Override
    public int getRowCount() {
        return this.model.getMetadataCount();
    }

    @Override
    public MetadataModel getRowMetadata() {
        return this.rowMetadataModel;
    }

    @Override
    public Class<?> getSeriesClass(int series) {
        return null;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public String getSeriesName(int series) {
        return null;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        Object value = this.model.get(rowIndex).getValue(columnIndex);
        return value instanceof Number ? ((Number)value).floatValue() : Float.NaN;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex, int seriesIndex) {
        if (seriesIndex != 0) {
            return Float.NaN;
        }
        Object value = this.model.get(rowIndex).getValue(columnIndex);
        return value instanceof Number ? ((Number)value).floatValue() : Float.NaN;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setProperty(Object key, Object value) {
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, float value) {
        this.model.get(rowIndex).setValue(columnIndex, Float.valueOf(value));
    }
}

