/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public class MetadataModelColumnView
implements MetadataModel {
    private int[] indices;
    private MetadataModel metadata;
    private Map<String, Integer> nameToIndex = new HashMap<String, Integer>();

    public MetadataModelColumnView(MetadataModel metadata, int[] indices) {
        this.metadata = metadata;
        this.indices = indices;
        this.buildMap();
    }

    @Override
    public Vector add(String columnName, Class<?> columnClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector get(int columnIndex) {
        return this.metadata.get(this.indices[columnIndex]);
    }

    @Override
    public Vector get(String name) {
        int index = this.getColumnIndex(name);
        return index == -1 ? null : this.metadata.get(this.indices[index]);
    }

    @Override
    public int getColumnIndex(String columnName) {
        Integer index = this.nameToIndex.get(columnName);
        return index != null ? index : -1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.metadata.getColumnName(this.indices[columnIndex]);
    }

    @Override
    public int getItemCount() {
        return this.metadata.getItemCount();
    }

    @Override
    public Object getValue(int rowIndex, int columnIndex) {
        return this.metadata.getValue(rowIndex, this.indices[columnIndex]);
    }

    @Override
    public Object getValue(int rowIndex, String columnName) {
        return this.metadata.getValue(rowIndex, columnName);
    }

    @Override
    public void remove(int columnIndex) {
        this.metadata.remove(this.indices[columnIndex]);
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, Object aValue) {
        this.metadata.setValue(rowIndex, this.indices[columnIndex], aValue);
    }

    @Override
    public void setValue(int rowIndex, String columnName, Object aValue) {
        this.metadata.setValue(rowIndex, columnName, aValue);
    }

    @Override
    public int getMetadataCount() {
        return this.indices.length;
    }

    private void buildMap() {
        this.nameToIndex.clear();
        int length = this.indices.length;
        for (int i = 0; i < length; ++i) {
            this.nameToIndex.put(this.getColumnName(i), i);
        }
    }
}

