/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public class MissingRowsDataset
implements Dataset {
    private Dataset dataset;
    private List<String> missingRowIds;
    private MetadataModel rowMetadata;

    public MissingRowsDataset(Dataset dataset, List<String> missingRowIds) {
        this.dataset = dataset;
        this.missingRowIds = missingRowIds;
        this.rowMetadata = new MissingMetadata(dataset.getRowMetadata(), this.getRowCount());
    }

    @Override
    public int getColumnCount() {
        return this.dataset.getColumnCount();
    }

    @Override
    public MetadataModel getColumnMetadata() {
        return this.dataset.getColumnMetadata();
    }

    @Override
    public String getName() {
        return this.dataset.getName();
    }

    @Override
    public Object getObjectValue(int rowIndex, int columnIndex, int seriesIndex) {
        return rowIndex < this.dataset.getRowCount() ? this.dataset.getObjectValue(rowIndex, columnIndex, seriesIndex) : null;
    }

    @Override
    public Object getProperty(Object key) {
        return this.dataset.getProperty(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.dataset.getPropertyKeys();
    }

    @Override
    public int getRowCount() {
        return this.dataset.getRowCount() + this.missingRowIds.size();
    }

    @Override
    public MetadataModel getRowMetadata() {
        return this.rowMetadata;
    }

    @Override
    public Class<?> getSeriesClass(int series) {
        return this.dataset.getSeriesClass(series);
    }

    @Override
    public int getSeriesCount() {
        return this.dataset.getSeriesCount();
    }

    @Override
    public String getSeriesName(int series) {
        return this.dataset.getSeriesName(series);
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        return rowIndex < this.dataset.getRowCount() ? this.dataset.getValue(rowIndex, columnIndex) : Float.NaN;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex, int seriesIndex) {
        return rowIndex < this.dataset.getRowCount() ? this.dataset.getValue(rowIndex, columnIndex, seriesIndex) : Float.NaN;
    }

    @Override
    public void setName(String name) {
        this.dataset.setName(name);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.dataset.setProperty(key, value);
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, float value) {
        throw new UnsupportedOperationException();
    }

    private static class MissingVector
    implements Vector {
        private Vector column;
        private int rowCount;

        public MissingVector(Vector v, int rowCount) {
            this.column = v;
            this.rowCount = rowCount;
        }

        @Override
        public Class<?> getColumnClass() {
            return this.column.getColumnClass();
        }

        @Override
        public Comparator<Object> getComparator() {
            return this.column.getComparator();
        }

        @Override
        public String getName() {
            return this.column.getName();
        }

        @Override
        public Object getProperty(Object key) {
            return this.column.getProperty(key);
        }

        @Override
        public Collection<Object> getPropertyKeys() {
            return this.column.getPropertyKeys();
        }

        @Override
        public void removeProperty(Object key) {
            this.column.removeProperty(key);
        }

        @Override
        public Object getValue(int index) {
            return index < this.column.size() ? this.column.getValue(index) : null;
        }

        @Override
        public void setColumnClass(Class<?> columnClass) {
            this.column.setColumnClass(columnClass);
        }

        @Override
        public void setComparator(Comparator<Object> comparator) {
            this.column.setComparator(comparator);
        }

        @Override
        public void setProperty(Object key, Object value) {
            this.column.setProperty(key, value);
        }

        @Override
        public void setValue(int index, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.rowCount;
        }
    }

    private static class MissingMetadata
    implements MetadataModel {
        private MetadataModel metadata;
        private int rowCount;

        public MissingMetadata(MetadataModel metadata, int rowCount) {
            if (metadata == null) {
                throw new NullPointerException("Metadata is null");
            }
            this.metadata = metadata;
            this.rowCount = rowCount;
        }

        @Override
        public Vector add(String columnName, Class<?> columnClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Vector get(int columnIndex) {
            return new MissingVector(this.metadata.get(columnIndex), this.rowCount);
        }

        @Override
        public Vector get(String name) {
            int index = this.metadata.getColumnIndex(name);
            return index == -1 ? null : new MissingVector(this.metadata.get(index), this.rowCount);
        }

        @Override
        public int getColumnIndex(String columnName) {
            return this.metadata.getColumnIndex(columnName);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.metadata.getColumnName(columnIndex);
        }

        @Override
        public int getMetadataCount() {
            return this.metadata.getMetadataCount();
        }

        @Override
        public int getItemCount() {
            return this.rowCount;
        }

        @Override
        public Object getValue(int rowIndex, int columnIndex) {
            return rowIndex < this.metadata.getItemCount() ? this.metadata.getValue(rowIndex, columnIndex) : null;
        }

        @Override
        public Object getValue(int rowIndex, String columnName) {
            return rowIndex < this.metadata.getItemCount() ? this.metadata.getValue(rowIndex, columnName) : null;
        }

        @Override
        public void remove(int columnIndex) {
            this.metadata.remove(columnIndex);
        }

        @Override
        public void setValue(int rowIndex, int columnIndex, Object aValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(int rowIndex, String columnName, Object aValue) {
            throw new UnsupportedOperationException();
        }
    }
}

