/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.matrix.AbstractDataset;
import org.broadinstitute.genee.matrix.AbstractMetadataModel;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.ResizableVector;
import org.broadinstitute.genee.matrix.Vector;

public class ResizableRowsDataset
extends AbstractDataset {
    private int columnCount;
    private MetadataModel columnMetadataModel;
    private MetadataModel rowMetadataModel;
    private List<float[]> values = new ArrayList<float[]>();

    public ResizableRowsDataset(String name, int columnCount) {
        this.name = name;
        this.columnCount = columnCount;
        this.columnMetadataModel = new DefaultMetadataModel(columnCount);
        this.rowMetadataModel = new ResizableMetadataModel(){

            @Override
            public int getItemCount() {
                return ResizableRowsDataset.this.getRowCount();
            }
        };
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public MetadataModel getColumnMetadata() {
        return this.columnMetadataModel;
    }

    public MetadataModel getColumnMetadataModel() {
        return this.columnMetadataModel;
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    @Override
    public MetadataModel getRowMetadata() {
        return this.rowMetadataModel;
    }

    public MetadataModel getRowMetadataModel() {
        return this.rowMetadataModel;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        return this.values.get(rowIndex)[columnIndex];
    }

    public void nextRow() {
        this.values.add(new float[this.columnCount]);
        for (AbstractDataset.Matrix m : this.matrices) {
            ((ResizableMatrix)m).next();
        }
        ((ResizableMetadataModel)this.rowMetadataModel).next();
    }

    public void setColumnMetadata(MetadataModel columnMetadataModel) {
        this.columnMetadataModel = columnMetadataModel;
    }

    public void setRowMetadata(MetadataModel rowMetadataModel) {
        this.rowMetadataModel = rowMetadataModel;
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, float value) {
        this.values.get((int)rowIndex)[columnIndex] = value;
    }

    @Override
    protected AbstractDataset.Matrix createMatrix() {
        return new ResizableMatrix();
    }

    private static abstract class ResizableMetadataModel
    extends AbstractMetadataModel {
        private ResizableMetadataModel() {
        }

        public void next() {
            int count = this.getMetadataCount();
            for (int i = 0; i < count; ++i) {
                ((ResizableVector)this.get(i)).next();
            }
        }

        @Override
        protected Vector createVector(String name, Class<?> c) {
            return new ResizableVector(name, c);
        }
    }

    private class ResizableMatrix
    implements AbstractDataset.Matrix {
        private List<Object[]> values = new ArrayList<Object[]>();

        private ResizableMatrix() {
        }

        public void next() {
            this.values.add(new Object[ResizableRowsDataset.this.columnCount]);
        }

        @Override
        public Object get(int row, int column) {
            return this.values.get(row)[column];
        }

        @Override
        public void set(int row, int column, Object value) {
            this.values.get((int)row)[column] = value;
        }
    }
}

