/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.Collection;
import java.util.Comparator;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Vector;

public class SlicedVector
implements Vector {
    private Vector vector;
    private int[] indices;

    public SlicedVector(Vector vector, int[] indices) {
        this.vector = vector;
        if (indices == null) {
            indices = IOUtil.seqInt(0, vector.size(), 1);
        }
        this.indices = indices;
    }

    @Override
    public Class<?> getColumnClass() {
        return this.vector.getColumnClass();
    }

    @Override
    public Comparator<Object> getComparator() {
        return this.vector.getComparator();
    }

    public int[] getIndices() {
        return this.indices;
    }

    @Override
    public String getName() {
        return this.vector.getName();
    }

    @Override
    public void removeProperty(Object key) {
        this.vector.removeProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        return this.vector.getProperty(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.vector.getPropertyKeys();
    }

    @Override
    public Object getValue(int index) {
        return this.vector.getValue(this.indices[index]);
    }

    public Vector getVector() {
        return this.vector;
    }

    @Override
    public void setColumnClass(Class<?> columnClass) {
        this.vector.setColumnClass(columnClass);
    }

    @Override
    public void setComparator(Comparator<Object> comparator) {
        this.vector.setComparator(comparator);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.vector.setProperty(key, value);
    }

    @Override
    public void setValue(int index, Object value) {
        this.vector.setValue(this.indices[index], value);
    }

    @Override
    public int size() {
        return this.indices.length;
    }

    public String toString() {
        return this.vector.toString();
    }
}

