/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import chemaxon.struc.Molecule;
import com.google.common.collect.Sets;
import com.jidesoft.comparator.FastComparableComparator;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.net.URL;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.genee.compound.MolarConcentration;
import org.broadinstitute.genee.gui.Combination;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.ComparableComparator;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class VectorUtil {
    private static final Map<Class<?>, Comparator> classToComparator = new LinkedHashMap();

    private VectorUtil() {
    }

    public static DefaultClassVector asClassVector(Vector column) {
        Object[] x = new Object[column.size()];
        int nrows = column.size();
        for (int i = 0; i < nrows; ++i) {
            x[i] = column.getValue(i);
        }
        return new DefaultClassVector(x);
    }

    public static FloatList asFloatList(final Vector vector) {
        return new FloatList(){

            @Override
            public float getValue(int index) {
                Object number = vector.getValue(index);
                return number instanceof Number ? ((Number)number).floatValue() : Float.NaN;
            }

            @Override
            public void setValue(int index, float value) {
                vector.setValue(index, Float.valueOf(value));
            }

            @Override
            public int size() {
                return vector.size();
            }
        };
    }

    public static <T> List<T> asList(final Vector vector) {
        return new AbstractList(){

            @Override
            public Object get(int index) {
                return vector.getValue(index);
            }

            @Override
            public int size() {
                return vector.size();
            }
        };
    }

    public static OrientedVector asOrientedVector(final Vector vector, final boolean rowVector) {
        return new OrientedVector(){

            public boolean equals(Object object) {
                return vector.equals(object);
            }

            @Override
            public Class<?> getColumnClass() {
                return vector.getColumnClass();
            }

            @Override
            public Comparator<Object> getComparator() {
                return vector.getComparator();
            }

            @Override
            public String getName() {
                return vector.getName();
            }

            @Override
            public Object getProperty(Object key) {
                return vector.getProperty(key);
            }

            @Override
            public Collection<Object> getPropertyKeys() {
                return vector.getPropertyKeys();
            }

            @Override
            public Object getValue(int index) {
                return vector.getValue(index);
            }

            public int hashCode() {
                return vector.hashCode();
            }

            @Override
            public boolean isRowVector() {
                return rowVector;
            }

            @Override
            public void removeProperty(Object key) {
                vector.removeProperty(key);
            }

            @Override
            public void setColumnClass(Class<?> columnClass) {
                vector.setColumnClass(columnClass);
            }

            @Override
            public void setComparator(Comparator<Object> comparator) {
                vector.setComparator(comparator);
            }

            @Override
            public void setProperty(Object key, Object value) {
                vector.setProperty(key, value);
            }

            @Override
            public void setValue(int index, Object value) {
                vector.setValue(index, value);
            }

            @Override
            public int size() {
                return vector.size();
            }

            public String toString() {
                return vector.toString();
            }
        };
    }

    public static Vector asVector(final String name, final List<?> values) {
        return new Vector(){
            private Comparator<Object> comparator;
            private Map<Object, Object> properties = new HashMap<Object, Object>();

            @Override
            public Class<?> getColumnClass() {
                int size = values.size();
                for (int i = 0; i < size; ++i) {
                    Object value = values.get(i);
                    if (value == null) continue;
                    return value.getClass();
                }
                return Object.class;
            }

            @Override
            public Comparator<Object> getComparator() {
                return this.comparator;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Object getProperty(Object key) {
                return this.properties.get(key);
            }

            @Override
            public Collection<Object> getPropertyKeys() {
                return this.properties.keySet();
            }

            @Override
            public Object getValue(int index) {
                return values.get(index);
            }

            @Override
            public void removeProperty(Object key) {
                this.properties.remove(key);
            }

            @Override
            public void setColumnClass(Class<?> columnClass) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setComparator(Comparator<Object> comparator) {
                this.comparator = comparator;
            }

            @Override
            public void setProperty(Object key, Object value) {
                this.properties.put(key, value);
            }

            @Override
            public void setValue(int index, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return values.size();
            }
        };
    }

    public static Vector asVector(final String name, final Object[] values) {
        return new Vector(){
            private Comparator<Object> comparator;
            private Map<Object, Object> properties = new HashMap<Object, Object>();

            @Override
            public Class<?> getColumnClass() {
                for (Object value : values) {
                    if (value == null) continue;
                    return value.getClass();
                }
                return Object.class;
            }

            @Override
            public Comparator<Object> getComparator() {
                return this.comparator;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Object getProperty(Object key) {
                return this.properties.get(key);
            }

            @Override
            public Collection<Object> getPropertyKeys() {
                return this.properties.keySet();
            }

            @Override
            public Object getValue(int index) {
                return values[index];
            }

            @Override
            public void removeProperty(Object key) {
                this.properties.remove(key);
            }

            @Override
            public void setColumnClass(Class<?> columnClass) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setComparator(Comparator<Object> comparator) {
                this.comparator = comparator;
            }

            @Override
            public void setProperty(Object key, Object value) {
                this.properties.put(key, value);
            }

            @Override
            public void setValue(int index, Object value) {
                values[index] = value;
            }

            @Override
            public int size() {
                return values.length;
            }
        };
    }

    public static <T> Map<T, Integer> buildIndexMap(Vector vector) {
        LinkedHashMap<Object, Integer> map = new LinkedHashMap<Object, Integer>();
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            map.put(vector.getValue(i), i);
        }
        return map;
    }

    public static void copyProperties(Vector src, Vector dest) {
        Collection<Object> keys = src.getPropertyKeys();
        for (Object key : keys) {
            dest.setProperty(key, src.getProperty(key));
        }
    }

    public static int countNonNull(Vector vector) {
        int n1 = 0;
        int count = vector.size();
        for (int i = 0; i < count; ++i) {
            Object value = vector.getValue(i);
            if (value == null) continue;
            ++n1;
        }
        return n1;
    }

    public static Identifier createIdentifier(MetadataModel model, String[] fields, int itemIndex) {
        int nvectors = fields.length;
        Vector[] vectors = new Vector[nvectors];
        for (int j = 0; j < nvectors; ++j) {
            vectors[j] = model.get(fields[j]);
        }
        return VectorUtil.createIdentifier(model, vectors, itemIndex);
    }

    public static Identifier createIdentifier(MetadataModel model, Vector[] vectors, int itemIndex) {
        int nvectors = vectors.length;
        Object[] array = new Object[nvectors];
        for (int j = 0; j < nvectors; ++j) {
            array[j] = vectors[j].getValue(itemIndex);
        }
        return new Identifier<Object>(array);
    }

    public static Map<Identifier, TIntArrayList> createIdentityValuesToIndicesMap(int size) {
        LinkedHashMap<Identifier, TIntArrayList> idToIndices = new LinkedHashMap<Identifier, TIntArrayList>();
        for (int i = 0; i < size; ++i) {
            TIntArrayList list = new TIntArrayList(1);
            list.add(i);
            idToIndices.put(new Identifier<Integer>(i), list);
        }
        return idToIndices;
    }

    public static Map<String, TIntArrayList> createStringValueToIndicesMap(Vector vector) {
        HashMap<String, TIntArrayList> map = new HashMap<String, TIntArrayList>();
        int cols = vector.size();
        for (int j = 0; j < cols; ++j) {
            Object value = vector.getValue(j);
            String val = Formatter.toString(value);
            TIntArrayList list = (TIntArrayList)map.get(val);
            if (list == null) {
                list = new TIntArrayList();
                map.put(val, list);
            }
            list.add(j);
        }
        return map;
    }

    public static Map<Identifier, Integer> createValuesToIndexMapStripDuplicates(Vector[] vectors) {
        if (vectors == null) {
            throw new NullPointerException("Vectors array is null.");
        }
        HashSet<Identifier<Object>> dups = new HashSet<Identifier<Object>>();
        LinkedHashMap<Identifier, Integer> idToIndex = new LinkedHashMap<Identifier, Integer>();
        int nvectors = vectors.length;
        int n = vectors[0].size();
        for (int i = 0; i < n; ++i) {
            Object[] array = new Object[nvectors];
            for (int j = 0; j < nvectors; ++j) {
                array[j] = vectors[j].getValue(i);
            }
            Identifier<Object> id = new Identifier<Object>(array);
            if (idToIndex.containsKey(id)) {
                dups.add(id);
            }
            idToIndex.put(id, i);
        }
        for (Identifier identifier : dups) {
            idToIndex.remove(identifier);
        }
        return idToIndex;
    }

    public static Map<Identifier, Integer> createValuesToIndexMap(Vector[] vectors) {
        if (vectors == null) {
            throw new NullPointerException("Vectors array is null.");
        }
        LinkedHashMap<Identifier, Integer> idToIndex = new LinkedHashMap<Identifier, Integer>();
        int nvectors = vectors.length;
        int rows = vectors[0].size();
        for (int i = 0; i < rows; ++i) {
            Object[] array = new Object[nvectors];
            for (int j = 0; j < nvectors; ++j) {
                array[j] = vectors[j].getValue(i);
            }
            Identifier<Object> id = new Identifier<Object>(array);
            if (idToIndex.containsKey(id)) {
                throw new IllegalArgumentException("Duplicate key: " + id);
            }
            idToIndex.put(id, i);
        }
        return idToIndex;
    }

    public static Map<Identifier, TIntArrayList> createValuesToIndicesMap(Vector[] vectors) {
        if (vectors == null) {
            throw new NullPointerException("Vectors array is null.");
        }
        LinkedHashMap<Identifier, TIntArrayList> idToIndices = new LinkedHashMap<Identifier, TIntArrayList>();
        int nvectors = vectors.length;
        if (nvectors == 0) {
            throw new IllegalArgumentException();
        }
        int rows = vectors[0].size();
        for (int i = 0; i < rows; ++i) {
            Object[] array = new Object[nvectors];
            for (int j = 0; j < nvectors; ++j) {
                array[j] = vectors[j].getValue(i);
            }
            Identifier<Object> id = new Identifier<Object>(array);
            TIntArrayList indices = (TIntArrayList)idToIndices.get(id);
            if (indices == null) {
                indices = new TIntArrayList();
                idToIndices.put(id, indices);
            }
            indices.add(i);
        }
        return idToIndices;
    }

    public static <T> Map<T, Integer> createValueToIndexMap(Vector vector) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            Object val = vector.getValue(i);
            if (map.containsKey(val)) {
                throw new IllegalArgumentException("Duplicate value: " + val + " in " + vector.getName());
            }
            map.put(val, i);
        }
        return map;
    }

    public static <T> Map<T, Integer> createValueToIndexMapStripDuplicates(Vector vector) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        HashSet<Object> dups = new HashSet<Object>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object val = vector.getValue(i);
            if (map.containsKey(val)) {
                dups.add(val);
            }
            map.put(val, i);
        }
        for (Object e : dups) {
            map.remove(e);
        }
        return map;
    }

    public static <T> Map<T, TIntArrayList> createValueToIndicesMap(Vector vector) {
        HashMap<Object, TIntArrayList> map = new HashMap<Object, TIntArrayList>();
        if (vector == null) {
            throw new NullPointerException("vector is null");
        }
        int cols = vector.size();
        for (int j = 0; j < cols; ++j) {
            Object val = vector.getValue(j);
            TIntArrayList list = (TIntArrayList)map.get(val);
            if (list == null) {
                list = new TIntArrayList();
                map.put(val, list);
            }
            list.add(j);
        }
        return map;
    }

    public static List<Combination> getCombinations(Vector[] vectors) {
        ArrayList<Combination> combinations = new ArrayList<Combination>();
        if (vectors == null || vectors.length == 0) {
            return combinations;
        }
        int maxItems = 0;
        for (Vector v : vectors) {
            maxItems = Math.max(v.size(), maxItems);
        }
        LinkedHashMap valuesToColumnIndices = new LinkedHashMap();
        for (int j = 0; j < maxItems; ++j) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Vector v : vectors) {
                Object val = j < v.size() ? v.getValue(j) : null;
                values.add(val);
            }
            LinkedHashSet<Integer> indices = (LinkedHashSet<Integer>)valuesToColumnIndices.get(values);
            if (indices == null) {
                indices = new LinkedHashSet<Integer>();
                valuesToColumnIndices.put(values, indices);
            }
            indices.add(j);
        }
        for (Collection values : valuesToColumnIndices.keySet()) {
            Combination c = new Combination(values, (Set)valuesToColumnIndices.get(values));
            combinations.add(c);
        }
        Comparator[] comparators = new Comparator[vectors.length];
        int length = vectors.length;
        for (int i = 0; i < length; ++i) {
            comparators[i] = vectors[i].getComparator();
        }
        Collections.sort(combinations, new CombinationComparator(comparators));
        return combinations;
    }

    public static Comparator getDefaultComparator(Class<?> c) {
        for (Class<?> test : classToComparator.keySet()) {
            if (!test.isAssignableFrom(c)) continue;
            return classToComparator.get(test);
        }
        return new Comparators.ObjectComparator();
    }

    public static int[] getIndices(Vector sourceVector, Collection<?> values) {
        if (sourceVector == null) {
            throw new NullPointerException("sourceVector is null.");
        }
        if (values == null) {
            throw new NullPointerException("values is null.");
        }
        TIntArrayList indices = new TIntArrayList();
        Map valueToIndices = VectorUtil.createValueToIndicesMap(sourceVector);
        for (Object val : values) {
            TIntArrayList list = valueToIndices.get(val);
            if (list == null) continue;
            indices.addAll((TIntCollection)list);
        }
        return indices.toArray();
    }

    public static float getJaccard(Vector v1, Vector v2) {
        Set<Integer> n1 = VectorUtil.getNonNullIndices(v1);
        Set<Integer> n2 = VectorUtil.getNonNullIndices(v2);
        float intersection = Sets.intersection(n1, n2).size();
        float union = Sets.union(n1, n2).size();
        return intersection / union;
    }

    public static float getMax(Vector vector) {
        FloatList list = VectorUtil.asFloatList(vector);
        return FloatListStatUtils.max(list);
    }

    public static float getMin(Vector vector) {
        FloatList list = VectorUtil.asFloatList(vector);
        return FloatListStatUtils.min(list);
    }

    public static int getNegativeToZeroIndex(RankedList rankedList) {
        for (int i = rankedList.size() - 1; i >= 0; --i) {
            float f = rankedList.getScore(i);
            if (!(f >= 0.0f)) continue;
            return i;
        }
        return -1;
    }

    public static Set<Integer> getNonNullIndices(Vector vector) {
        HashSet<Integer> set = new HashSet<Integer>();
        int count = vector.size();
        for (int i = 0; i < count; ++i) {
            Object value = vector.getValue(i);
            if (value == null) continue;
            set.add(i);
        }
        return set;
    }

    public static int getPositiveToZeroIndex(RankedList rankedList) {
        int size = rankedList.size();
        for (int i = 0; i < size; ++i) {
            float f = rankedList.getScore(i);
            if (!(f <= 0.0f)) continue;
            return i;
        }
        return -1;
    }

    public static <T> Set<T> getValues(Vector vector) {
        AbstractSet set = null;
        set = vector.getComparator() != null ? new TreeSet<Object>(vector.getComparator()) : (Comparable.class.isAssignableFrom(vector.getColumnClass()) ? new TreeSet(FastComparableComparator.getInstance()) : new LinkedHashSet());
        int nrows = vector.size();
        for (int i = 0; i < nrows; ++i) {
            Object val = vector.getValue(i);
            set.add((Object)val);
        }
        return set;
    }

    public static boolean containsMoreThanOneValue(Vector vector) {
        HashSet<Object> set = new HashSet<Object>();
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            Object value = vector.getValue(i);
            if (value == null) continue;
            set.add(value);
            if (set.size() <= 1) continue;
            return true;
        }
        return set.size() > 1;
    }

    public static int getValues(Vector vector, int maxValues) {
        HashSet<Object> set = new HashSet<Object>();
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            Object value = vector.getValue(i);
            if (value == null) continue;
            set.add(value);
            if (set.size() != maxValues) continue;
            return set.size();
        }
        return set.size();
    }

    public static int[] reorder(Vector vector, Map<?, Integer> valueToIndex) {
        TIntArrayList list = new TIntArrayList();
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            Integer index = valueToIndex.get(vector.getValue(i));
            if (index == null) continue;
            list.add(index.intValue());
        }
        return list.toArray();
    }

    public static DefaultClassVector toClassVector(Vector vector, String classA, String classB) {
        Object[] x = new String[vector.size()];
        int cols = vector.size();
        for (int j = 0; j < cols; ++j) {
            Object value = vector.getValue(j);
            if (classA.equals(value)) {
                x[j] = classA;
                continue;
            }
            if (!classB.equals(value)) continue;
            x[j] = classB;
        }
        return new DefaultClassVector(x, new String[]{classA, classB});
    }

    public static Object firstNullNull(Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Object val = v.getValue(i);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    static {
        classToComparator.put(String.class, Comparators.getStringCaseInsensitiveOrder());
        classToComparator.put(Number.class, ComparableComparator.INSTANCE);
        classToComparator.put(Float.TYPE, ComparableComparator.INSTANCE);
        classToComparator.put(Integer.TYPE, ComparableComparator.INSTANCE);
        classToComparator.put(Date.class, ComparableComparator.INSTANCE);
        classToComparator.put(MolarConcentration.class, ComparableComparator.INSTANCE);
        classToComparator.put(URL.class, new Comparators.ObjectComparator());
        try {
            classToComparator.put(Molecule.class, new Comparators.ObjectComparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class CombinationComparator
    implements Comparator<Combination> {
        private Comparator[] comparators;

        public CombinationComparator(Comparator[] comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(Combination c1, Combination c2) {
            Iterator<Object> v1 = c1.getValues().iterator();
            Iterator<Object> v2 = c2.getValues().iterator();
            int index = 0;
            while (v1.hasNext()) {
                Object o1 = v1.next();
                Object o2 = v2.next();
                int result = this.comparators[index] != null ? this.comparators[index].compare(o1, o2) : 0;
                if (result != 0) {
                    return result;
                }
                ++index;
            }
            return 0;
        }
    }
}

