/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix.rankedlist;

import gnu.trove.list.array.TFloatArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelItemView;
import org.broadinstitute.genee.matrix.TroveFloatList;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;
import org.broadinstitute.genee.stats.Sorting;

public class AverageRankedList
implements RankedList {
    private RankedList rankedList;
    private HashMap<Object, Integer> idToIndex;
    private int positiveToZeroIndex;
    private int negativeToZeroIndex;
    private Object[] ids;
    private float[] scores;
    private MetadataModelItemView metadata;

    public AverageRankedList(RankedList ... rankedLists) {
        this.rankedList = rankedLists[0];
        int size = this.rankedList.size();
        TFloatArrayList values = new TFloatArrayList();
        int nlists = rankedLists.length;
        for (int i = 0; i < size; ++i) {
            Object id = this.rankedList.getId(i);
            TFloatArrayList floatList = new TFloatArrayList();
            for (int j = 0; j < nlists; ++j) {
                RankedList rl = rankedLists[j];
                int index = rl.getIndex(id);
                float score = rl.getScore(index);
                floatList.add(score);
            }
            float mean = FloatListStatUtils.mean(new TroveFloatList(floatList));
            values.add(mean);
        }
        int[] indices = Sorting.index(values, false);
        System.out.println(ToStringUtil.toString(indices, ", "));
        this.metadata = new MetadataModelItemView(this.rankedList.getMetadata(), indices);
        this.ids = new Object[size];
        this.idToIndex = new HashMap();
        this.scores = new float[size];
        for (int i = 0; i < size; ++i) {
            Object id;
            int index = indices[i];
            this.ids[i] = id = this.rankedList.getId(index);
            this.idToIndex.put(id, i);
            this.scores[i] = values.getQuick(index);
        }
        this.positiveToZeroIndex = VectorUtil.getPositiveToZeroIndex(this);
        this.negativeToZeroIndex = VectorUtil.getNegativeToZeroIndex(this);
    }

    @Override
    public Object getId(int index) {
        return this.ids[index];
    }

    @Override
    public int getIndex(Object id) {
        Integer index = this.idToIndex.get(id);
        return index != null ? index : -1;
    }

    @Override
    public MetadataModel getMetadata() {
        return this.metadata;
    }

    @Override
    public String getName() {
        return "Mean";
    }

    @Override
    public int getNegativeToZeroIndex() {
        return this.negativeToZeroIndex;
    }

    @Override
    public int getPositiveToZeroIndex() {
        return this.positiveToZeroIndex;
    }

    @Override
    public Object getProperty(Object key) {
        return this.rankedList.getProperty(key);
    }

    @Override
    public void removeProperty(Object key) {
        this.rankedList.removeProperty(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.rankedList.getPropertyKeys();
    }

    @Override
    public float getScore(int index) {
        return this.scores[index];
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.rankedList.setProperty(key, value);
    }

    @Override
    public int size() {
        return this.rankedList.size();
    }
}

