/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix.rankedlist;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class RankedListDataset
implements Dataset {
    private RankedList rl;
    private DefaultMetadataModel rowMetadata;
    private DefaultMetadataModel columnMetadata;
    private Map<Object, Object> properties = new HashMap<Object, Object>();

    public RankedListDataset(RankedList rl) {
        this.rl = rl;
        this.rowMetadata = new DefaultMetadataModel(rl.size());
        this.columnMetadata = new DefaultMetadataModel(1);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public MetadataModel getColumnMetadata() {
        return this.columnMetadata;
    }

    @Override
    public String getName() {
        return this.rl.getName();
    }

    @Override
    public Object getObjectValue(int rowIndex, int columnIndex, int seriesIndex) {
        return Float.valueOf(this.getValue(rowIndex, columnIndex));
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public int getRowCount() {
        return this.rl.size();
    }

    @Override
    public MetadataModel getRowMetadata() {
        return this.rowMetadata;
    }

    @Override
    public Class<?> getSeriesClass(int series) {
        return null;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public String getSeriesName(int series) {
        return null;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        return this.rl.getScore(rowIndex);
    }

    @Override
    public float getValue(int rowIndex, int columnIndex, int seriesIndex) {
        return this.getValue(rowIndex, columnIndex);
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public void setValue(int rowIndex, int columnINdex, float value) {
        throw new UnsupportedOperationException();
    }

    private static class RankedListIdVector
    implements Vector {
        private RankedList rl;
        private Comparator<Object> c;

        private RankedListIdVector() {
        }

        @Override
        public Class<?> getColumnClass() {
            return String.class;
        }

        @Override
        public Comparator<Object> getComparator() {
            return this.c;
        }

        @Override
        public String getName() {
            return this.rl.getName();
        }

        @Override
        public Object getProperty(Object key) {
            return this.rl.getProperty(key);
        }

        @Override
        public Collection<Object> getPropertyKeys() {
            return this.rl.getPropertyKeys();
        }

        @Override
        public Object getValue(int index) {
            return this.rl.getId(index);
        }

        @Override
        public void setColumnClass(Class<?> columnClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setComparator(Comparator<Object> comparator) {
            this.c = comparator;
        }

        @Override
        public void removeProperty(Object key) {
            this.rl.removeProperty(key);
        }

        @Override
        public void setProperty(Object key, Object value) {
            this.rl.setProperty(key, value);
        }

        @Override
        public void setValue(int index, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.rl.size();
        }
    }
}

