/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class FromGeneeServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String fileType = req.getParameter("fileType");
        if (fileType == null || fileType.equals("")) {
            fileType = "gctx";
        }
        resp.setContentType("application/" + fileType);
        resp.setStatus(200);
        Project p = Application.getProject();
        if (p == null) {
            throw new IOException("Nothing is opened in GENE-E.");
        }
        Dataset dataset = p.getOriginalDataset();
        resp.addHeader("filename", dataset.getName());
        dataset = DatasetUtil.sliceView(dataset, p.getModelRowIndices(p.getRowSelectionModel().getSelectionCount() > 0, true), p.getModelColumnIndices(p.getColumnSelectionModel().getSelectionCount() > 0, true));
        File file = File.createTempFile("temp", "." + fileType, IOUtil.getTmpFsDir());
        ProjectIO.writeProject((Project)new DefaultProject(dataset), fileType, file.getCanonicalPath());
        IOUtil.copy(new FileInputStream(file), (OutputStream)resp.getOutputStream());
        file.delete();
    }
}

