/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.server;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.servlet.Filter;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.server.FromGeneeServlet;
import org.broadinstitute.genee.server.ToGeneeServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlets.GzipFilter;

public class GeneeServer {
    private static GeneeServer instance;
    private static final String LISTEN_PORT = "listen.port";
    private int port = Preferences.userNodeForPackage(Application.class).getInt("listen.port", 9998);
    private Server server;

    private GeneeServer() {
        if (System.getProperty("genee.port") != null) {
            this.port = Integer.parseInt(System.getProperty("genee.port").trim());
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    public void setPort(int port) {
        this.port = port;
        Preferences p = Preferences.userNodeForPackage(Application.class);
        p.putInt(LISTEN_PORT, port);
        try {
            p.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public boolean start() {
        if ("true".equals(System.getProperty("org.broadinstitute.genee.commandLine"))) {
            return false;
        }
        try {
            this.server = new Server();
            SelectChannelConnector http = new SelectChannelConnector();
            http.setPort(this.port);
            this.server.addConnector((Connector)http);
            ServletHandler handler = new ServletHandler();
            handler.addFilter(new FilterHolder((Filter)new GzipFilter()));
            this.server.setHandler((Handler)handler);
            handler.addServletWithMapping(ToGeneeServlet.class, "/api/to");
            handler.addServletWithMapping(FromGeneeServlet.class, "/api/from");
            this.server.start();
            System.out.println("Listening on port " + this.port);
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    public boolean stop() {
        try {
            this.server.stop();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static synchronized GeneeServer getInstance() {
        if (instance == null) {
            instance = new GeneeServer();
        }
        return instance;
    }

    static {
        Preferences p = Preferences.userNodeForPackage(Application.class);
        if (p.getBoolean("listen.incoming", true) || System.getProperty("genee.port") != null) {
            try {
                GeneeServer.getInstance().start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

