/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.table.IconAdapter;
import org.broadinstitute.genee.table.SortKey;

public abstract class AbstractSortableHeaderRenderer
extends DefaultTableCellRenderer {
    public static final Icon ASC_ICON = new ImageIcon(AbstractSortableHeaderRenderer.class.getResource("/org/broadinstitute/genee/resources/primary_sorted_asc.png"));
    public static final Icon ASC_ICON2 = new ImageIcon(AbstractSortableHeaderRenderer.class.getResource("/org/broadinstitute/genee/resources/secondary_sorted_asc.png"));
    public static final Icon DESC_ICON = new ImageIcon(AbstractSortableHeaderRenderer.class.getResource("/org/broadinstitute/genee/resources/primary_sorted_desc.png"));
    public static final Icon DESC_ICON2 = new ImageIcon(AbstractSortableHeaderRenderer.class.getResource("/org/broadinstitute/genee/resources/secondary_sorted_desc.png"));
    private boolean allowGroup;
    private boolean sortingEnabled = true;

    public AbstractSortableHeaderRenderer(JTableHeader tableHeader, boolean allowGroup) {
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
        tableHeader.addMouseListener(new MouseHandler());
        this.allowGroup = allowGroup;
        this._setToolTipText();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        int modelColumnIndex = table.convertColumnIndexToModel(column);
        int sortKeyIndex = this.getSortKeyForColumnName(table.getModel().getColumnName(modelColumnIndex));
        if (sortKeyIndex == -1) {
            this.setIcon(null);
        } else {
            this.setIcon(this.getIcon(this.getSortKeys().get(sortKeyIndex), sortKeyIndex));
        }
        return this;
    }

    public boolean isSortingEnabled() {
        return this.sortingEnabled;
    }

    public void setSortingEnabled(boolean sortingEnabled) {
        this.sortingEnabled = sortingEnabled;
        this._setToolTipText();
    }

    public void setSortingStatus(List<? extends SortKey> sortKeys, SortKey sortKey, boolean additionalSort, boolean isGroupBy) {
        if (sortKey.getSortOrder() == SortOrder.UNSORTED && !additionalSort) {
            this.clearSorting();
        } else {
            if (additionalSort && sortKeys.size() == 0) {
                additionalSort = false;
            }
            List<SortKey> newSortKeys = null;
            if (!additionalSort) {
                newSortKeys = Arrays.asList(sortKey);
            } else {
                int sortKeyIndex = sortKeys.indexOf(sortKey);
                if (sortKeyIndex == -1) {
                    newSortKeys = new ArrayList<SortKey>(sortKeys);
                    newSortKeys.add(sortKey);
                } else {
                    newSortKeys = new ArrayList<SortKey>(sortKeys);
                    newSortKeys.set(sortKeyIndex, sortKey);
                }
            }
            this.setOrder(newSortKeys);
        }
        if (isGroupBy) {
            this.setGroupBy(new SortKey[]{sortKey});
        }
        this.repaint();
    }

    protected abstract void setGroupBy(SortKey[] var1);

    protected abstract void clearSorting();

    protected abstract SortKey createSortKey(String var1);

    protected Icon getIcon(SortKey sortKey, int sortIndex) {
        if (sortKey.getSortOrder().equals((Object)SortOrder.UNSORTED)) {
            return null;
        }
        if (sortKey.getSortOrder().equals((Object)SortOrder.ASCENDING)) {
            return sortIndex == 0 ? ASC_ICON : new IconAdapter(ASC_ICON2, sortIndex);
        }
        if (sortKey.getSortOrder().equals((Object)SortOrder.DESCENDING)) {
            return sortIndex == 0 ? DESC_ICON : new IconAdapter(DESC_ICON2, sortIndex);
        }
        return null;
    }

    protected abstract List<? extends SortKey> getSortKeys();

    protected abstract void setOrder(List<? extends SortKey> var1);

    private void _setToolTipText() {
        if (this.sortingEnabled) {
            if (this.allowGroup) {
                this.setToolTipText("Click to sort. Shift-click to sort multiple columns simultaneously. Alt-click to group.");
            } else {
                this.setToolTipText("Click to sort. Shift-click to sort multiple columns simultaneously.");
            }
        } else {
            this.setToolTipText(null);
        }
    }

    private int getSortKeyForColumnName(String columnName) {
        List<? extends SortKey> sortKeys = this.getSortKeys();
        if (sortKeys != null) {
            int size = sortKeys.size();
            for (int i = 0; i < size; ++i) {
                if (!columnName.equals(sortKeys.get(i).toString())) continue;
                return i;
            }
        }
        return -1;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SortOrder sortOrder;
            SortKey sortKey;
            if (e.isPopupTrigger() || !SwingUtilities.isLeftMouseButton(e) || e.isControlDown() || !AbstractSortableHeaderRenderer.this.sortingEnabled) {
                return;
            }
            boolean additionalSort = e.isShiftDown();
            boolean isGroupBy = AbstractSortableHeaderRenderer.this.allowGroup && e.isAltDown();
            JTableHeader tableHeader = (JTableHeader)e.getSource();
            TableColumnModel columnModel = tableHeader.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int modelColumnIndex = tableHeader.getTable().convertColumnIndexToModel(viewColumn);
            if (modelColumnIndex < 0) {
                return;
            }
            String columnName = tableHeader.getTable().getModel().getColumnName(modelColumnIndex);
            int existingSortKeyIndex = AbstractSortableHeaderRenderer.this.getSortKeyForColumnName(columnName);
            if (existingSortKeyIndex != -1) {
                sortKey = AbstractSortableHeaderRenderer.this.getSortKeys().get(existingSortKeyIndex);
                sortOrder = sortKey.getSortOrder() == SortOrder.UNSORTED ? SortOrder.ASCENDING : (sortKey.getSortOrder() == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.UNSORTED);
            } else {
                sortKey = AbstractSortableHeaderRenderer.this.createSortKey(columnName);
                sortOrder = SortOrder.ASCENDING;
            }
            if (sortKey != null) {
                sortKey.setSortOrder(sortOrder);
                AbstractSortableHeaderRenderer.this.setSortingStatus(AbstractSortableHeaderRenderer.this.getSortKeys(), sortKey, additionalSort, isGroupBy);
            }
        }
    }
}

