/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import gnu.trove.list.array.TIntArrayList;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.io.util.Formatter;

public class CopyTableAction
extends AbstractAction {
    private JTable focusedTable;
    private JTable[] tables;
    private boolean[] transposedTables;

    public CopyTableAction(JTable[] tables, boolean[] transposedTables) {
        super("Copy");
        KeyStroke ks = null;
        if (!GraphicsEnvironment.isHeadless()) {
            ks = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        String cmd = (String)this.getValue("Name");
        FocusListener l = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CopyTableAction.this.focusedTable = (JTable)e.getComponent();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        for (JTable table : tables) {
            if (table == null) {
                throw new NullPointerException("Table is null");
            }
            table.getActionMap().put(cmd, this);
            if (ks != null) {
                table.getInputMap(0).put(ks, cmd);
            }
            table.addFocusListener(l);
        }
        if (ks != null) {
            this.putValue("AcceleratorKey", ks);
        }
        this.tables = tables;
        this.transposedTables = transposedTables;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.focusedTable != null) {
            this.copy();
        }
    }

    private void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        int[] selectedRows = this.focusedTable.getSelectedRows();
        int[] selectedColumns = this.focusedTable.getSelectedColumns();
        TIntArrayList newSelectedColumns = new TIntArrayList();
        int length = selectedColumns.length;
        for (int j = 0; j < length; ++j) {
            newSelectedColumns.add(selectedColumns[j]);
        }
        boolean transposed = false;
        int length2 = this.tables.length;
        for (int i = 0; i < length2; ++i) {
            if (this.tables[i] != this.focusedTable) continue;
            transposed = this.transposedTables[i];
            break;
        }
        StringBuilder buf = CopyTableAction.getSelectedData(this.focusedTable, selectedRows, newSelectedColumns.toArray(), transposed);
        StringSelection stringSelection = new StringSelection(buf.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    private static StringBuilder getSelectedData(JTable table, int[] selectedRows, int[] selectedColumns, boolean transposedTable) {
        StringBuilder buf = new StringBuilder();
        if (!transposedTable) {
            for (int i = 0; i < selectedRows.length; ++i) {
                if (i > 0) {
                    buf.append("\n");
                }
                for (int j = 0; j < selectedColumns.length; ++j) {
                    Object value;
                    if (j > 0) {
                        buf.append("\t");
                    }
                    buf.append((value = table.getValueAt(selectedRows[i], selectedColumns[j])) != null ? Formatter.toString(value) : "");
                }
            }
        } else {
            for (int j = 0; j < selectedColumns.length; ++j) {
                if (j > 0) {
                    buf.append("\n");
                }
                for (int i = 0; i < table.getRowCount(); ++i) {
                    Object value;
                    if (i > 0) {
                        buf.append("\t");
                    }
                    buf.append((value = table.getValueAt(i, selectedColumns[j])) != null ? Formatter.toString(value) : "");
                }
            }
        }
        return buf;
    }
}

