/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class HeatMapColumnTableModel
extends AbstractTableModel {
    private Dataset dataset;
    private MetadataModel metadataModel;
    private Map<Integer, HeatMapColumnTableRowType> map;
    private Project project;
    private ProjectListener projectListener = new ProjectListener(){

        @Override
        public void projectChanged(ProjectEvent e) {
            if (e.isColumnChanged()) {
                HeatMapColumnTableModel.this.setDataset(HeatMapColumnTableModel.this.project.getSortedFilteredDataset());
            }
        }
    };
    private boolean curveSummaryVisible;

    @Override
    public void fireTableStructureChanged() {
        this.metadataModel = this.dataset != null ? MetadataUtil.getTextColumns(this.dataset.getColumnMetadata()) : null;
        this.buildMap();
        super.fireTableStructureChanged();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.dataset != null ? this.dataset.getColumnCount() : 0;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Project getProject() {
        return this.project;
    }

    public Class<?> getRowClass(int rowIndex) {
        HeatMapColumnTableRowType row = this.map.get(rowIndex);
        if (row.id == 1) {
            return CurveElementList.class;
        }
        return this.metadataModel.get(row.index).getColumnClass();
    }

    @Override
    public int getRowCount() {
        int count = 0;
        if (this.metadataModel != null) {
            count += this.metadataModel.getMetadataCount();
        }
        if (this.curveSummaryVisible) {
            ++count;
        }
        return count;
    }

    public String getMetadataRowName(int rowIndex) {
        HeatMapColumnTableRowType row = this.map.get(rowIndex);
        if (row == null || row.id != 2) {
            return null;
        }
        return this.metadataModel.getColumnName(row.index);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HeatMapColumnTableRowType row = this.map.get(rowIndex);
        if (row == null) {
            return null;
        }
        if (row.id == 1) {
            return this.dataset;
        }
        Object obj = this.metadataModel.getValue(columnIndex, this.metadataModel.getColumnName(row.index));
        return obj;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public boolean isCurveSummaryVisible() {
        return this.curveSummaryVisible;
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        project.addProjectListener(this.projectListener);
        this.project = project;
        if (project.getOriginalDataset() != null) {
            this.setDataset(project.getSortedFilteredDataset());
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    Vector getAsVector(int rowIndex) {
        HeatMapColumnTableRowType row = this.map.get(rowIndex);
        if (row.id == 2) {
            return this.metadataModel.get(row.index);
        }
        return null;
    }

    private void buildMap() {
        this.map = new HashMap<Integer, HeatMapColumnTableRowType>();
        int rowIndex = 0;
        if (this.metadataModel != null) {
            int i = 0;
            int size = this.metadataModel.getMetadataCount();
            while (i < size) {
                this.map.put(rowIndex, new HeatMapColumnTableRowType(2, i));
                ++i;
                ++rowIndex;
            }
        }
        boolean bl = this.dataset == null ? false : (this.curveSummaryVisible = DatasetUtil.getSeriesIndex(this.dataset, CurveElementList.class) != -1);
        if (this.curveSummaryVisible) {
            this.map.put(rowIndex, new HeatMapColumnTableRowType(1, rowIndex));
        }
    }

    private void setDataset(Dataset dataset) {
        this.dataset = dataset;
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                HeatMapColumnTableModel.this.fireTableStructureChanged();
            }
        });
    }

    private static class HeatMapColumnTableRowType {
        private static final int CHART_ID = 1;
        private static final int META_DATA_ID = 2;
        private int id;
        private int index;

        public HeatMapColumnTableRowType(int id, int index) {
            this.id = id;
            this.index = index;
        }

        public String toString() {
            return this.id + ", " + this.index;
        }
    }
}

