/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.MetadataModel;

public class HeatMapDrag
implements Transferable {
    private Project project;
    private int[] modelIndices;
    protected String metadataFieldName;
    private boolean isRows;
    private static List<DataFlavor> flavorList;
    private static DataFlavor[] flavors;

    public HeatMapDrag(Project project, int[] modelIndices, String metadataFieldName, boolean isRows) {
        this.project = project;
        this.modelIndices = modelIndices;
        this.metadataFieldName = metadataFieldName;
        this.isRows = isRows;
    }

    public List<String> getItems() {
        int[] indices = this.getModelIndices();
        MetadataModel metadata = this.isRows ? this.getProject().getOriginalDataset().getRowMetadata() : this.getProject().getOriginalDataset().getColumnMetadata();
        ArrayList<String> items = new ArrayList<String>();
        if (this.metadataFieldName == null) {
            for (int i : indices) {
                items.add(ToStringUtil.toString(metadata, i));
            }
        } else {
            for (int i : indices) {
                items.add(Formatter.toString(metadata.get(this.metadataFieldName).getValue(i)));
            }
        }
        return items;
    }

    public String getMetadataFieldName() {
        return this.metadataFieldName;
    }

    public int[] getModelIndices() {
        return this.modelIndices;
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavorList.contains(flavor);
    }

    public String toString() {
        return ToStringUtil.toString(this.getItems(), ", ");
    }

    static {
        try {
            flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref")};
            flavorList = Arrays.asList(flavors);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

