/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.gui.UIUtil;

public class SelectAllActionTableInFocus
extends AbstractAction {
    private JTable focusedTable;

    public SelectAllActionTableInFocus(JTable ... tables) {
        this("Select All", tables);
    }

    public SelectAllActionTableInFocus(String text, JTable ... tables) {
        super(text);
        KeyStroke ks = null;
        if (!GraphicsEnvironment.isHeadless()) {
            ks = KeyStroke.getKeyStroke(65, UIUtil.getMenuShortcutKeyMask());
        }
        String selectAllCommand = (String)this.getValue("Name");
        FocusListener l = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SelectAllActionTableInFocus.this.focusedTable = (JTable)e.getComponent();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        for (JTable table : tables) {
            table.getActionMap().put(selectAllCommand, this);
            if (ks != null) {
                table.getInputMap(0).put(ks, selectAllCommand);
            }
            table.addFocusListener(l);
        }
        if (ks != null) {
            this.putValue("AcceleratorKey", ks);
        }
        this.focusedTable = tables.length > 0 ? tables[0] : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.focusedTable != null) {
            this.focusedTable.selectAll();
        }
    }
}

