/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.MiniProfilePlot;
import org.broadinstitute.genee.heatmap.SparklineTableCellRenderer;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;

public abstract class TableDrawer
implements Drawable {
    private TIntArrayList viewColumns;
    private int[] columnWidths;
    private int height;
    private MiniProfilePlot miniProfilePlot = new MiniProfilePlot();
    private int profileWidth = 60;
    private int spaceBetweenColumns = 10;
    protected JTable table;
    private int width;
    private int leftBorder = 4;
    public static final int MAX_FONT_SIZE = 30;
    private int maximumCharactersClip = -1;

    public TableDrawer(JTable table) {
        this.table = table;
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        Graphics2D g2 = (Graphics2D)g;
        Font savedFont = g2.getFont();
        AffineTransform t = g2.getTransform();
        float fontSize = this.getRowSize();
        if (fontSize > 30.0f) {
            fontSize = 30.0f;
        }
        float halfSize = this.getRowSize() / 2.0f;
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(Color.BLACK);
        this.drawHeader(g2);
        Font font = this.table.getFont().deriveFont(0, fontSize);
        g2.setFont(font);
        int rowStart = this.getRowStart(clip);
        int rowEnd = this.getRowEnd(clip);
        if (this.viewColumns.size() > 0) {
            TableModel tableModel = this.table.getModel();
            for (int i = rowStart; i < rowEnd; ++i) {
                float y = this.getPosition(i) - 1.0f;
                int x = this.leftBorder;
                int modelRow = this.table.convertRowIndexToModel(i);
                int cols = this.viewColumns.size();
                for (int j = 0; j < cols; ++j) {
                    int viewColumn = this.viewColumns.getQuick(j);
                    int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
                    Object value = tableModel.getValueAt(modelRow, modelColumn);
                    if (!this.drawValue(value)) continue;
                    g.setColor(this.getColor(modelRow, modelColumn));
                    if (value != null) {
                        Class<?> columnClass = tableModel.getColumnClass(modelColumn);
                        if (String.class.isAssignableFrom(columnClass)) {
                            String s = (String)value;
                            s = this.maximumCharactersClip == -1 ? s : UIUtil.trim(s, this.maximumCharactersClip);
                            g2.drawString(s, (float)x, y);
                        } else if (IOUtil.isNumber(columnClass)) {
                            String s = Formatter.format((Number)value);
                            s = this.maximumCharactersClip == -1 ? s : UIUtil.trim(s, this.maximumCharactersClip);
                            g2.drawString(s, (float)x, y);
                        } else if (Dataset.class.isAssignableFrom(columnClass)) {
                            this.miniProfilePlot.setSize(this.profileWidth, this.table.getRowHeight(i));
                            float ty = y - (float)this.table.getRowHeight(i);
                            g2.translate((double)x, ty);
                            this.miniProfilePlot.draw((Graphics2D)g, (Dataset)value, i, SparklineTableCellRenderer.DEFAULT_COLOR);
                            g2.translate((double)(-x), -ty);
                        } else {
                            try {
                                TableCellRenderer rend = this.table.getCellRenderer(modelRow, viewColumn);
                                int cellHeight = this.table.getCellRect((int)0, (int)viewColumn, (boolean)true).height;
                                if (rend != null) {
                                    Component comp = rend.getTableCellRendererComponent(this.table, value, false, false, i, viewColumn);
                                    comp.setBackground(Color.WHITE);
                                    JPanel panel = new JPanel();
                                    float ty = y;
                                    g2.translate((double)x, ty);
                                    Dimension size = new Dimension(this.columnWidths[viewColumn], cellHeight);
                                    comp.setBounds(new Rectangle(size));
                                    panel.add(comp);
                                    comp.print(g2);
                                    g2.translate((double)(-x), -ty);
                                    g2.setFont(font);
                                }
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    x += this.columnWidths[j] + this.spaceBetweenColumns;
                }
            }
        }
        g2.setTransform(t);
        g2.setFont(savedFont);
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    @Override
    public Dimension getDrawableSize() {
        return new Dimension(this.width + this.leftBorder, this.height);
    }

    public void init() {
        this.viewColumns = new TIntArrayList();
        int cols = this.table.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            this.viewColumns.add(j);
        }
        this.computeColumnWidths();
    }

    public void setColumnWidths(int[] columnWidths) {
        this.columnWidths = columnWidths;
        this.width = 0;
        for (int cw : columnWidths) {
            this.width += cw + this.spaceBetweenColumns;
        }
    }

    public void setMaximumCharactersClip(int maximumCharactersClip) {
        this.maximumCharactersClip = maximumCharactersClip;
    }

    protected boolean drawValue(Object value) {
        return true;
    }

    protected Color getColor(int row, int column) {
        return Color.BLACK;
    }

    protected abstract float getPosition(int var1);

    protected abstract int getRowEnd(Rectangle var1);

    protected abstract int getRowStart(Rectangle var1);

    protected abstract float getRowSize();

    private void computeColumnWidths() {
        this.width = 0;
        this.columnWidths = new int[this.viewColumns.size()];
        float fontSize = this.getRowSize();
        if (fontSize > 30.0f) {
            fontSize = 30.0f;
        }
        TableModel model = this.table.getModel();
        FontMetrics fm = this.table.getFontMetrics(this.table.getFont().deriveFont(0, fontSize));
        int cols = this.viewColumns.size();
        for (int j = 0; j < cols; ++j) {
            int viewColumn = this.viewColumns.get(j);
            int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
            Class<?> c = model.getColumnClass(modelColumn);
            int maxWidth = fm.stringWidth(model.getColumnName(j));
            int rows = this.table.getRowCount();
            for (int i = 0; i < rows; ++i) {
                String s;
                int modelRow = this.table.convertRowIndexToModel(i);
                Object value = model.getValueAt(modelRow, modelColumn);
                if (value == null) continue;
                if (String.class.isAssignableFrom(c)) {
                    s = (String)value;
                    s = this.maximumCharactersClip == -1 ? s : UIUtil.trim(s, this.maximumCharactersClip);
                    maxWidth = Math.max(maxWidth, fm.stringWidth(s));
                    continue;
                }
                if (IOUtil.isNumber(c)) {
                    s = Formatter.format((Number)value);
                    s = this.maximumCharactersClip == -1 ? s : UIUtil.trim(s, this.maximumCharactersClip);
                    maxWidth = Math.max(maxWidth, fm.stringWidth(s));
                    continue;
                }
                if (DatasetRowView.class.isAssignableFrom(c)) {
                    maxWidth = Math.max(maxWidth, this.profileWidth);
                    continue;
                }
                TableCellRenderer rend = this.table.getCellRenderer(modelRow, modelColumn);
                Component comp = rend.getTableCellRendererComponent(this.table, value, false, false, modelRow, modelColumn);
                if (comp == null) continue;
                maxWidth = Math.max(maxWidth, comp.getPreferredSize().width);
            }
            this.columnWidths[j] = maxWidth;
            this.width += maxWidth + this.spaceBetweenColumns;
        }
        this.height = 0;
        this.height += fm.getHeight() + fm.getDescent();
        int rowCount = this.table.getRowCount();
        if (rowCount > 0 && this.table.getColumnCount() > 0) {
            Rectangle r = this.table.getCellRect(rowCount - 1, 0, true);
            this.height = r.y + r.height;
        }
    }

    private void drawHeader(Graphics2D g2) {
        g2.translate(0, -g2.getFontMetrics().getDescent() - 3);
        int x = this.leftBorder;
        int cols = this.viewColumns.size();
        for (int j = 0; j < cols; ++j) {
            int viewColumn = this.viewColumns.getQuick(j);
            int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
            String s = this.table.getModel().getColumnName(modelColumn);
            s = this.maximumCharactersClip == -1 ? s : UIUtil.trim(s, this.maximumCharactersClip);
            g2.drawString(s, x, 0);
            x += this.columnWidths[j] + this.spaceBetweenColumns;
        }
        g2.translate(0, g2.getFontMetrics().getDescent() + 3);
    }
}

