/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;

public class CFCSDataSizing
implements CFCSErrorCodes {
    static final int FIXED = 0;
    static final int COLUMN = 1;
    static final int ROW = 2;
    private static final int BITSPERBYTE = 8;
    private int size = Integer.MIN_VALUE;
    private int[] sizes;
    private int[] byteSizes;
    private int[] rangeMasks;
    private int[] fieldMasks;
    private final CFCSKeywords keywords;
    private final CFCSParameters parameters;

    CFCSDataSizing(CFCSKeywords keywords) {
        this.keywords = keywords;
        this.parameters = new CFCSParameters(keywords);
    }

    int getSizeVariability() {
        return 0;
    }

    final boolean isVariableSize() {
        return this.getSizeVariability() != 0;
    }

    boolean isRangeMaskable() {
        return false;
    }

    final boolean isPackedData() {
        if (this.keywords.getDatatype() != 4) {
            return false;
        }
        int count = this.parameters.getCount();
        for (int i = 0; i < count; ++i) {
            CFCSParameter parameter = this.parameters.getParameter(i);
            if (parameter.getFieldSize() % 8 == 0) continue;
            return true;
        }
        return false;
    }

    final int getSize() {
        if (this.size == Integer.MIN_VALUE) {
            int count = this.parameters.getCount();
            if (count < 1) {
                throw new CFCSError(-10);
            }
            int max = Integer.MIN_VALUE;
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < count; ++i) {
                CFCSParameter parameter = this.parameters.getParameter(i);
                int width = parameter.getFieldSize();
                if (width > max) {
                    max = width;
                }
                if (width >= min) continue;
                min = width;
            }
            if (min == max) {
                this.size = min;
            } else {
                throw new CFCSError(-10);
            }
        }
        return this.size;
    }

    final int getByteSize() {
        return (this.getSize() + 7) / 8;
    }

    final int[] getSizes() {
        if (this.sizes == null) {
            int count = this.parameters.getCount();
            this.sizes = new int[count];
            for (int i = 0; i < count; ++i) {
                CFCSParameter parameter = this.parameters.getParameter(i);
                this.sizes[i] = parameter.getFieldSize();
            }
        }
        return this.sizes;
    }

    final int[] getByteSizes() {
        if (this.byteSizes == null) {
            int[] sizes = this.getSizes();
            boolean ascii = this.keywords.getDatatype() == 1;
            this.byteSizes = new int[sizes.length];
            for (int i = 0; i < sizes.length; ++i) {
                this.byteSizes[i] = ascii ? sizes[i] : (sizes[i] + 7) / 8;
            }
        }
        return this.byteSizes;
    }

    final int[] getRangeMasks() {
        if (this.rangeMasks == null) {
            int count = this.parameters.getCount();
            this.rangeMasks = new int[count];
            for (int i = 0; i < count; ++i) {
                CFCSParameter parameter = this.parameters.getParameter(i);
                this.rangeMasks[i] = CFCSDataSizing.makeRangeMask(parameter.getRange());
            }
        }
        return this.rangeMasks;
    }

    private static int makeRangeMask(int range) {
        int mask = 1;
        --range;
        while ((range | mask) != mask) {
            mask = (mask << 1) + 1;
        }
        return mask;
    }

    final int[] getFieldMasks() {
        if (this.fieldMasks == null) {
            int[] sizes = this.getSizes();
            this.fieldMasks = new int[sizes.length];
            for (int i = 0; i < sizes.length; ++i) {
                this.fieldMasks[i] = (1 << sizes[i]) - 1;
            }
        }
        return this.fieldMasks;
    }
}

