/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSDatatypeBinary;
import org.flowcyt.cfcs.CFCSError;

public final class CFCSDatatypeASCII
extends CFCSDatatypeBinary {
    private static final byte END_OF_LINE_CHAR = 10;

    @Override
    public final void readData(int index, byte[][] cinch) {
        int[] row = new int[cinch.length];
        for (int cell = 0; cell < cinch.length; ++cell) {
            try {
                row[cell] = new Integer(new String(cinch[cell]).trim());
                continue;
            }
            catch (NumberFormatException exception) {
                throw new CFCSError(-10, (Throwable)exception);
            }
        }
        if (index == this.data.size()) {
            this.data.add(row);
        } else {
            this.data.set(index, row);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public final void writeData(int index, int count, DataOutputStream stream) {
        int[] row = (int[])this.data.get(index);
        int[] sizes = this.sizing.getSizes();
        try {
            int i = 0;
            while (i < count) {
                int width = sizes[i];
                byte[] bytes = Long.toString((long)row[i] & 0xFFFFFFFFL).getBytes();
                if (width > 0) {
                    int j;
                    int pad = Math.max(width - bytes.length, 0);
                    for (j = 0; j < pad; ++j) {
                        stream.write(32);
                    }
                    for (j = 0; j < width - pad; ++j) {
                        stream.write(bytes[j]);
                    }
                } else {
                    if (i > 0) {
                        stream.write(44);
                    }
                    stream.write(bytes);
                    if (i == count - 1) {
                        stream.write(10);
                    }
                }
                ++i;
            }
            return;
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
    }
}

