/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSDatatypeDouble;
import org.flowcyt.cfcs.CFCSError;

public final class CFCSDatatypeFloat
extends CFCSDatatypeDouble {
    @Override
    public final void readData(int index, byte[][] cinch) {
        float[] row = new float[cinch.length];
        for (int cell = 0; cell < cinch.length; ++cell) {
            int datum = cinch[cell][0] & 0xFF;
            for (int i = 1; i < cinch[cell].length; ++i) {
                datum = datum << 8 | cinch[cell][i] & 0xFF;
            }
            row[cell] = Float.intBitsToFloat(datum);
        }
        if (index == this.data.size()) {
            this.data.add(row);
        } else {
            this.data.set(index, row);
        }
    }

    @Override
    public final void writeData(int index, int count, DataOutputStream stream) {
        float[] row = (float[])this.data.get(index);
        try {
            for (int i = 0; i < count; ++i) {
                stream.writeFloat(row[i]);
            }
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
    }

    @Override
    public final void getData(int index, float[] array) {
        float[] row = (float[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        System.arraycopy(row, 0, array, 0, row.length);
    }

    @Override
    public final void getData(int index, double[] array) {
        float[] row = (float[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            array[i] = row[i];
        }
    }

    @Override
    public final void setData(int index, float[] array) {
        float[] row = (float[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
        System.arraycopy(array, 0, row, 0, array.length);
    }

    @Override
    public final void setData(int index, double[] array) {
        float[] row = (float[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            row[i] = (float)array[i];
        }
    }

    @Override
    public final void addData(float[] array) {
        float[] row = new float[array.length];
        System.arraycopy(array, 0, row, 0, array.length);
        this.data.add(row);
    }

    @Override
    public final void addData(double[] array) {
        float[] row = new float[array.length];
        for (int i = 0; i < row.length; ++i) {
            row[i] = (float)array[i];
        }
        this.data.add(row);
    }
}

