/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.util.HashMap;
import java.util.Map;
import org.flowcyt.cfcs.CFCSErrorCodes;

public final class CFCSError
extends RuntimeException
implements CFCSErrorCodes {
    private static final Map errors = new HashMap();
    public int errorNumber = 0;
    public String additionalInformation = null;
    public CFCSError nextError = null;

    CFCSError() {
        this.errorNumber = -10;
    }

    CFCSError(int errorNumber) {
        this.errorNumber = errorNumber;
    }

    CFCSError(int errorNumber, String additionalInformation) {
        this(errorNumber);
        this.additionalInformation = additionalInformation;
    }

    CFCSError(int errorNumber, Throwable exception) {
        this(errorNumber, exception.getMessage());
    }

    CFCSError(int errorNumber, int additionalInformation) {
        this(errorNumber, Integer.toString(additionalInformation));
    }

    CFCSError(int errorNumber, double additionalInformation) {
        this(errorNumber, Double.toString(additionalInformation));
    }

    CFCSError(int errorNumber, CFCSError nextError) {
        this(errorNumber);
        this.nextError = nextError;
    }

    public final String getErrorMessage() {
        Integer key = new Integer(this.errorNumber);
        if (errors.containsKey(key)) {
            return (String)errors.get(key);
        }
        return null;
    }

    @Override
    public final String toString() {
        String message = this.getErrorMessage();
        if (this.additionalInformation != null) {
            message = message + ": " + this.additionalInformation;
        }
        return message;
    }

    static {
        errors.put(new Integer(-36), "CFCSNoSuchBin");
        errors.put(new Integer(-35), "CFCSInsufficientSpace");
        errors.put(new Integer(-34), "CFCSInsufficientData");
        errors.put(new Integer(-33), "CFCSNotImplemented");
        errors.put(new Integer(-32), "CFCSCannotModifySource");
        errors.put(new Integer(-31), "CFCSIllegalName");
        errors.put(new Integer(-30), "CFCSKeywordUndefined");
        errors.put(new Integer(-29), "CFCSNoSuchDataSet");
        errors.put(new Integer(-28), "CFCSBadSourceSet");
        errors.put(new Integer(-27), "CFCSParametersUndefined");
        errors.put(new Integer(-24), "CFCSParameterInclassesplete");
        errors.put(new Integer(-23), "CFCSInconsistentAttribute");
        errors.put(new Integer(-22), "CFCSCannotModifyValue");
        errors.put(new Integer(-21), "CFCSInconsistentValue");
        errors.put(new Integer(-20), "CFCSIllegalValue");
        errors.put(new Integer(-19), "CFCSBadValueConversion");
        errors.put(new Integer(-18), "CFCSBadKeywordIndex");
        errors.put(new Integer(-17), "CFCSKeywordExists");
        errors.put(new Integer(-16), "CFCSKeywordNotFound");
        errors.put(new Integer(-15), "CFCSIllegalSegment");
        errors.put(new Integer(-14), "CFCSIOError");
        errors.put(new Integer(-13), "CFCSStreamNotOpen");
        errors.put(new Integer(-12), "CFCSBadFCS");
        errors.put(new Integer(-10), "CFCSSystemError");
        errors.put(new Integer(-8), "CFCSNoSuchParameter");
        errors.put(new Integer(-7), "CFCSNoSuchEvent");
        errors.put(new Integer(-5), "CFCSFileNotCreated");
        errors.put(new Integer(-4), "CFCSVersionNotSupported");
        errors.put(new Integer(-3), "CFCSFileNotFCS");
        errors.put(new Integer(-2), "CFCSFileNotFound");
        errors.put(new Integer(-1), "CFCSStreamAlreadyOpen");
        errors.put(new Integer(0), "CFCSSuccess");
        errors.put(new Integer(1), "CFCSNotFCSclassespliant");
        errors.put(new Integer(2), "CFCSNetworkIOError");
        errors.put(new Integer(3), "CFCSSegmentNotPresent");
        errors.put(new Integer(4), "CFCSKeywordModified");
        errors.put(new Integer(5), "CFCSOutOfRange");
        errors.put(new Integer(6), "CFCSHistogramOutOfRange");
        errors.put(new Integer(7), "CFCSUndefinedAttribute");
    }
}

