/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.util.HashMap;
import java.util.Map;
import org.flowcyt.cfcs.CFCSAbstractParameters;
import org.flowcyt.cfcs.CFCSGatingParameter;
import org.flowcyt.cfcs.CFCSKeywords;

public final class CFCSGatingParameters
extends CFCSAbstractParameters {
    private final Map cache = new HashMap();
    private static final String GATE_PREFIX = "$G";
    private static final String[][] GATE_PROPERTIES = new String[][]{{"E", "LogDecadesAndOffset", "N"}, {"F", "Filter", "N"}, {"N", "ShortName", "N"}, {"P", "EmittedPercent", "N"}, {"R", "Range", "N"}, {"S", "FullName", "N"}, {"T", "DetectorType", "N"}, {"V", "Voltage", "N"}};

    CFCSGatingParameters(CFCSKeywords keywords) {
        super(keywords, CFCSGatingParameter.class);
    }

    @Override
    protected final String getPrefix() {
        return GATE_PREFIX;
    }

    @Override
    protected final String[][] getProperties() {
        return GATE_PROPERTIES;
    }

    @Override
    protected final String getCountKeyword() {
        return "$GATE";
    }

    static boolean isParameter(String keyword) {
        if (!(keyword = keyword.toUpperCase()).startsWith(GATE_PREFIX)) {
            return false;
        }
        String suffix = null;
        for (int i = 0; i < GATE_PROPERTIES.length; ++i) {
            String code = GATE_PROPERTIES[i][0];
            if (!keyword.endsWith(code)) continue;
            suffix = code;
            break;
        }
        if (suffix == null) {
            return false;
        }
        String root = keyword.substring(GATE_PREFIX.length(), keyword.length() - suffix.length());
        try {
            Integer.parseInt(root);
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    public final CFCSGatingParameter getParameter(int index) {
        Integer key = new Integer(index);
        if (this.cache.containsKey(key)) {
            return (CFCSGatingParameter)((CFCSGatingParameter)this.cache.get(key)).copy();
        }
        CFCSGatingParameter parameter = new CFCSGatingParameter();
        super.getParameter(index, parameter);
        this.cache.put(key, parameter.copy());
        return parameter;
    }

    public final void replaceParameter(int index, CFCSGatingParameter parameter) {
        super.replaceParameter(index, parameter);
        this.cache.remove(new Integer(index));
    }

    @Override
    public final void deleteParameter(int index) {
        super.deleteParameter(index);
        this.cache.remove(new Integer(index));
    }
}

