/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;

public final class CFCSKeyword
implements Cloneable,
CFCSErrorCodes {
    private static final char FCS_DEFINED_CHAR = '$';
    private String name = null;
    private String value = null;
    private int segIdx = -1;

    CFCSKeyword(String name, String value, int segIdx) {
        this.setKeywordName(name);
        this.setKeywordValue(value);
        this.setKeywordSource(segIdx);
    }

    CFCSKeyword(String name, String value) {
        this.setKeywordName(name);
        this.setKeywordValue(value);
        this.setKeywordSource(1);
    }

    CFCSKeyword(String name, int value) {
        this.setKeywordName(name);
        this.setKeywordIntegerValue(value);
        this.setKeywordSource(1);
    }

    CFCSKeyword(String name, long value) {
        this.setKeywordName(name);
        this.setKeywordLongValue(value);
        this.setKeywordSource(1);
    }

    static final boolean isSet(String value) {
        return value != null;
    }

    static final boolean isNotSet(String value) {
        return value == null;
    }

    final boolean isEmpty(String value) {
        return CFCSKeyword.isNotSet(value) || value.length() == 0;
    }

    final CFCSKeyword copy() {
        CFCSKeyword duplicate = null;
        try {
            duplicate = (CFCSKeyword)this.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new CFCSError(-10, (Throwable)exception);
        }
        return duplicate;
    }

    final boolean nameStartsWith(String prefix) {
        if (CFCSKeyword.isNotSet(this.name)) {
            throw new CFCSError(-30);
        }
        return this.name.toUpperCase().startsWith(prefix.toUpperCase());
    }

    final boolean isFCSDefined() {
        if (CFCSKeyword.isNotSet(this.name)) {
            throw new CFCSError(-30);
        }
        return this.name.charAt(0) == '$';
    }

    public CFCSKeyword() {
    }

    public final String getKeywordName() {
        if (CFCSKeyword.isNotSet(this.name)) {
            throw new CFCSError(-30);
        }
        return this.name;
    }

    public final void setKeywordName(String name) {
        if (this.isEmpty(name)) {
            throw new CFCSError(-31);
        }
        this.name = name;
    }

    public final String getKeywordValue() {
        if (CFCSKeyword.isNotSet(this.value)) {
            throw new CFCSError(-30);
        }
        return this.value;
    }

    public final void setKeywordValue(String value) {
        if (this.isEmpty(value)) {
            throw new CFCSError(-20);
        }
        this.value = value;
    }

    public final long getKeywordLongValue() {
        Long value = null;
        try {
            String s = this.getKeywordValue().trim();
            int n = s.indexOf(46);
            if (n > 0) {
                s = s.substring(0, n);
            }
            value = new Long(s);
        }
        catch (NumberFormatException exception) {
            throw new CFCSError(-19, (Throwable)exception);
        }
        return value;
    }

    public final void setKeywordLongValue(long value) {
        this.value = new Long(value).toString();
    }

    public final int getKeywordIntegerValue() {
        Integer value = null;
        try {
            String s = this.getKeywordValue().trim();
            int n = s.indexOf(46);
            if (n > 0) {
                s = s.substring(0, n);
            }
            value = new Integer(s);
        }
        catch (NumberFormatException exception) {
            throw new CFCSError(-19, (Throwable)exception);
        }
        return value;
    }

    public final void setKeywordIntegerValue(int value) {
        this.value = new Integer(value).toString();
    }

    public final double getKeywordDoubleValue() {
        Double value = null;
        try {
            value = new Double(this.getKeywordValue().trim());
        }
        catch (NumberFormatException exception) {
            throw new CFCSError(-19, (Throwable)exception);
        }
        return value;
    }

    public final void setKeywordDoubleValue(double value) {
        this.value = new Double(value).toString();
    }

    public final int getKeywordSource() {
        if (this.segIdx == -1) {
            throw new CFCSError(-30);
        }
        return this.segIdx;
    }

    public final void setKeywordSource(int segIdx) {
        if (segIdx < 4 && segIdx != 1 && segIdx != 3) {
            throw new CFCSError(-15, segIdx);
        }
        this.segIdx = segIdx;
    }

    public final String toString() {
        return this.getKeywordValue();
    }
}

