/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSGatingParameters;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSParameters;

public final class CFCSKeywords
implements CFCSErrorCodes {
    static final String DATATYPE_KEYWORD = "$DATATYPE";
    static final String GATE_KEYWORD = "$GATE";
    static final String MODE_KEYWORD = "$MODE";
    static final String PARAMETER_KEYWORD = "$PAR";
    static final String BYTEORDER_KEYWORD = "$BYTEORD";
    static final String FILE_KEYWORD = "$FIL";
    static final String NEXTDATA_KEYWORD = "$NEXTDATA";
    static final String TOTAL_KEYWORD = "$TOT";
    static final Set SYSTEM_KEYWORDS = new HashSet();
    static final Set NONTRANSFERABLE_KEYWORDS = new HashSet();
    static final String[] SEGMENT_ROOTS = new String[]{"HEADER", "STEXT", "DATA", "ANALYSIS"};
    static final String SEGMENT_BEGIN_PREFIX = "$BEGIN";
    static final String SEGMENT_END_PREFIX = "$END";
    private static final char DEFAULT_DELIMITER = '/';
    private static final char DELIMITER_GUARD = '_';
    private static final char[] delimiters;
    private static final char DELIMITER_UNDEFINED = '\u0000';
    private char delimiter = '\u0000';
    private static final int NUMBER = 0;
    private static final int LETTER = 1;
    private static final Object[][] DATATYPE_LOOKUP_TABLE;
    private static final Object[][] MODE_LOOKUP_TABLE;
    private final CFCSKeywordTable keywords = new CFCSKeywordTable();

    public final int getCount() {
        return this.keywords.size();
    }

    public final CFCSKeyword getKeyword(String name) {
        if (name == null || name.length() == 0) {
            throw new CFCSError(-31);
        }
        if (this.keywords.containsKeyword(name)) {
            return this.keywords.getKeyword(name).copy();
        }
        throw new CFCSError(-16, name);
    }

    public final CFCSKeyword getKeyword(int index) {
        if (index < 0 || index > this.keywords.size() - 1) {
            throw new CFCSError(-18, index);
        }
        return this.keywords.getKeyword(index).copy();
    }

    public final void addKeyword(CFCSKeyword keyword) {
        String name = keyword.getKeywordName();
        if (SYSTEM_KEYWORDS.contains(name)) {
            throw new CFCSError(-22, name);
        }
        if (CFCSParameters.isParameter(name) || CFCSGatingParameters.isParameter(name)) {
            throw new CFCSError(-22, name);
        }
        if (!this.keywords.containsKeyword(name)) {
            String value = keyword.getKeywordValue();
            int segIdx = keyword.getKeywordSource();
            this.keywords.addKeyword(new CFCSKeyword(name, value, segIdx));
        } else {
            this.replaceKeyword(keyword);
        }
    }

    public final void deleteKeyword(String name) {
        if (name == null || name.length() == 0) {
            throw new CFCSError(-31);
        }
        if (SYSTEM_KEYWORDS.contains(name)) {
            throw new CFCSError(-22, name);
        }
        if (!this.keywords.containsKeyword(name)) {
            throw new CFCSError(-16, name);
        }
        this.keywords.deleteKeyword(name);
    }

    public final void replaceKeyword(CFCSKeyword keyword) {
        CFCSKeyword existing;
        String name = keyword.getKeywordName();
        if (SYSTEM_KEYWORDS.contains(name)) {
            throw new CFCSError(-22, name);
        }
        if (this.keywords.containsKeyword(name)) {
            existing = this.keywords.getKeyword(name);
            int segIdx = keyword.getKeywordSource();
            if (segIdx != existing.getKeywordSource()) {
                throw new CFCSError(-32, segIdx);
            }
        } else {
            throw new CFCSError(-16, name);
        }
        existing.setKeywordValue(keyword.getKeywordValue());
    }

    final CFCSKeyword getSystemKeyword(String name) {
        if (this.keywords.containsKeyword(name)) {
            return this.keywords.getKeyword(name);
        }
        return null;
    }

    final CFCSKeyword getSystemKeyword(int index) {
        return this.keywords.getKeyword(index);
    }

    final void addSystemKeyword(CFCSKeyword keyword) {
        if (!this.keywords.containsKeyword(keyword.getKeywordName())) {
            this.keywords.addKeyword(keyword);
        } else {
            this.replaceSystemKeyword(keyword);
        }
    }

    final void replaceSystemKeyword(CFCSKeyword keyword) {
        CFCSKeyword existing;
        String name = keyword.getKeywordName();
        if (this.keywords.containsKeyword(name)) {
            existing = this.keywords.getKeyword(name);
            int segIdx = keyword.getKeywordSource();
            if (segIdx != existing.getKeywordSource()) {
                throw new CFCSError(-32, segIdx);
            }
        } else {
            throw new CFCSError(-16, name);
        }
        existing.setKeywordValue(keyword.getKeywordValue());
    }

    private static String escape(String string, char delimiter) {
        int end;
        int length = string.length();
        int start = 0;
        StringBuffer buffer = new StringBuffer();
        if (string.charAt(0) == delimiter) {
            buffer.append('_');
        }
        while (start < length && (end = string.indexOf(delimiter, start)) >= 0) {
            buffer.append(string.substring(start, ++end)).append(delimiter);
            start = end;
        }
        if (start == 0) {
            return string;
        }
        if (start < length) {
            buffer.append(string.substring(start, length));
        }
        return buffer.toString();
    }

    private char getDelimiter() {
        if (this.delimiter != '\u0000') {
            return this.delimiter;
        }
        int count = this.getCount();
        block0: for (int j = 0; j < delimiters.length; ++j) {
            char character = delimiters[j];
            for (int i = 0; i < count; ++i) {
                CFCSKeyword keyword = this.getSystemKeyword(i);
                if (keyword.getKeywordName().indexOf(character) > -1 || keyword.getKeywordValue().indexOf(character) > -1) continue block0;
            }
            this.delimiter = character;
            return this.delimiter;
        }
        this.delimiter = '/';
        return '/';
    }

    final void setBytes(byte[] buffer, int segIdx) {
        char delimiter = (char)buffer[0];
        boolean lastWasDelimiter = false;
        boolean readingKey = true;
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        int length = buffer.length;
        for (int i = 1; i < length; ++i) {
            char ch = (char)buffer[i];
            if (ch == delimiter) {
                if (lastWasDelimiter = !lastWasDelimiter) continue;
                (readingKey ? key : value).append(ch);
                continue;
            }
            if (lastWasDelimiter) {
                if (readingKey = !readingKey) {
                    this.addSystemKeyword(new CFCSKeyword(new String(key), new String(value), segIdx));
                    key = new StringBuffer();
                    value = new StringBuffer();
                }
                lastWasDelimiter = false;
            }
            (readingKey ? key : value).append(ch);
        }
        if (lastWasDelimiter && !readingKey) {
            this.addSystemKeyword(new CFCSKeyword(new String(key), new String(value), segIdx));
        }
    }

    final byte[] getBytes(int segIdx) {
        char delimiter = this.getDelimiter();
        StringBuffer buffer = new StringBuffer();
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            CFCSKeyword keyword = this.getSystemKeyword(i);
            if (keyword.getKeywordSource() != segIdx) continue;
            String name = CFCSKeywords.escape(keyword.getKeywordName(), delimiter);
            String value = CFCSKeywords.escape(keyword.getKeywordValue(), delimiter);
            buffer.append(delimiter).append(name).append(delimiter).append(value);
        }
        if (buffer.length() == 0) {
            return null;
        }
        buffer.append(delimiter);
        return buffer.toString().getBytes();
    }

    final byte[] getTextBytes(boolean want_fcs_defined) {
        int count = this.getCount();
        char delimiter = this.getDelimiter();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            CFCSKeyword keyword = this.getSystemKeyword(i);
            if (keyword.getKeywordSource() != 1) continue;
            boolean is_fcs_defined = keyword.isFCSDefined();
            if (want_fcs_defined && !is_fcs_defined || !want_fcs_defined && is_fcs_defined) continue;
            String name = CFCSKeywords.escape(keyword.getKeywordName(), delimiter);
            String value = CFCSKeywords.escape(keyword.getKeywordValue(), delimiter);
            buffer.append(delimiter).append(name).append(delimiter).append(value);
        }
        if (buffer.length() == 0) {
            return null;
        }
        buffer.append(delimiter);
        return buffer.toString().getBytes();
    }

    final int getDatatype() {
        String value = null;
        try {
            value = this.getKeyword(DATATYPE_KEYWORD).getKeywordValue();
        }
        catch (CFCSError error) {
            return 0;
        }
        for (int i = 0; i < DATATYPE_LOOKUP_TABLE.length; ++i) {
            if (!value.equalsIgnoreCase((String)DATATYPE_LOOKUP_TABLE[i][1])) continue;
            int type = (Integer)DATATYPE_LOOKUP_TABLE[i][0];
            return type;
        }
        return 0;
    }

    final void setDatatype(int type) {
        for (int i = 0; i < DATATYPE_LOOKUP_TABLE.length; ++i) {
            if (type != (Integer)DATATYPE_LOOKUP_TABLE[i][0]) continue;
            String value = (String)DATATYPE_LOOKUP_TABLE[i][1];
            this.addSystemKeyword(new CFCSKeyword(DATATYPE_KEYWORD, value));
            return;
        }
        throw new CFCSError(-20, type);
    }

    final int getMode() {
        String value = null;
        try {
            value = this.getKeyword(MODE_KEYWORD).getKeywordValue();
        }
        catch (CFCSError error) {
            return 0;
        }
        for (int i = 0; i < MODE_LOOKUP_TABLE.length; ++i) {
            if (!value.equalsIgnoreCase((String)MODE_LOOKUP_TABLE[i][1])) continue;
            return (Integer)MODE_LOOKUP_TABLE[i][0];
        }
        return 0;
    }

    final void setMode(int mode) {
        for (int i = 0; i < MODE_LOOKUP_TABLE.length; ++i) {
            if (mode != (Integer)MODE_LOOKUP_TABLE[i][0]) continue;
            String value = (String)MODE_LOOKUP_TABLE[i][1];
            this.addSystemKeyword(new CFCSKeyword(MODE_KEYWORD, value));
            return;
        }
        throw new CFCSError(-20, mode);
    }

    protected final int[] getByteSwapArray() {
        CFCSKeyword keyword = this.getSystemKeyword(BYTEORDER_KEYWORD);
        String string = keyword.getKeywordValue();
        LinkedList<Integer> positions = new LinkedList<Integer>();
        for (int i = 0; i < string.length(); ++i) {
            char character = string.charAt(i);
            if (!Character.isDigit(character)) continue;
            positions.add(new Integer(Character.digit(character, 10)));
        }
        int[] array = new int[positions.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)positions.get(i);
        }
        return array;
    }

    protected final void setByteSwapArray(int[] array) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (i >= array.length - 1) continue;
            buffer.append(',');
        }
        this.addSystemKeyword(new CFCSKeyword(BYTEORDER_KEYWORD, buffer.toString()));
    }

    static {
        SYSTEM_KEYWORDS.add(DATATYPE_KEYWORD);
        SYSTEM_KEYWORDS.add(GATE_KEYWORD);
        SYSTEM_KEYWORDS.add(MODE_KEYWORD);
        SYSTEM_KEYWORDS.add(PARAMETER_KEYWORD);
        NONTRANSFERABLE_KEYWORDS.add(BYTEORDER_KEYWORD);
        NONTRANSFERABLE_KEYWORDS.add(FILE_KEYWORD);
        NONTRANSFERABLE_KEYWORDS.add(NEXTDATA_KEYWORD);
        NONTRANSFERABLE_KEYWORDS.add(TOTAL_KEYWORD);
        for (int i = 1; i < 4; ++i) {
            NONTRANSFERABLE_KEYWORDS.add(SEGMENT_BEGIN_PREFIX + SEGMENT_ROOTS[i]);
            NONTRANSFERABLE_KEYWORDS.add(SEGMENT_END_PREFIX + SEGMENT_ROOTS[i]);
        }
        SYSTEM_KEYWORDS.addAll(NONTRANSFERABLE_KEYWORDS);
        delimiters = new char[]{'/', '#', '%', '*', '|', '!', '&', '+', ';', '\\', '~'};
        DATATYPE_LOOKUP_TABLE = new Object[][]{{new Integer(1), "A"}, {new Integer(2), "F"}, {new Integer(3), "D"}, {new Integer(4), "I"}};
        MODE_LOOKUP_TABLE = new Object[][]{{new Integer(1), "L"}, {new Integer(2), "C"}, {new Integer(3), "U"}};
    }

    private static final class CFCSKeywordTable {
        private final List list = new LinkedList();
        private final Map map = new HashMap();

        private CFCSKeywordTable() {
        }

        final int size() {
            return this.list.size();
        }

        final boolean containsKeyword(String name) {
            return this.map.containsKey(name.toUpperCase());
        }

        final CFCSKeyword getKeyword(String name) {
            return (CFCSKeyword)this.map.get(name.toUpperCase());
        }

        final CFCSKeyword getKeyword(int index) {
            return (CFCSKeyword)this.list.get(index);
        }

        final void addKeyword(CFCSKeyword keyword) {
            this.map.put(keyword.getKeywordName().toUpperCase(), keyword);
            this.list.add(keyword);
        }

        final void deleteKeyword(String name) {
            this.list.remove(this.map.remove(name.toUpperCase()));
        }
    }
}

