/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSAbstractData;
import org.flowcyt.cfcs.CFCSDataChannelError;
import org.flowcyt.cfcs.CFCSDataScaleError;
import org.flowcyt.cfcs.CFCSDataSizeError;
import org.flowcyt.cfcs.CFCSDataSizing;
import org.flowcyt.cfcs.CFCSDatatype;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSKeywords;

public final class CFCSListModeData
extends CFCSAbstractData
implements CFCSErrorCodes {
    CFCSListModeData(CFCSDatatype datatype, CFCSKeywords keywords) {
        super(1, datatype, keywords);
        this.sizing = new CFCSDataSizing(keywords){

            @Override
            public int getSizeVariability() {
                return 1;
            }

            @Override
            public boolean isRangeMaskable() {
                return true;
            }
        };
        datatype.setSizingObject(this.sizing);
    }

    @Override
    protected final byte[][][] cinchBytes(byte[] bytes) {
        int[] sizes = null;
        int size = 0;
        int nEvents = this.getCount();
        int nParameters = this.parameters.getCount();
        boolean variable = this.sizing.getSizeVariability() != 0;
        byte[][][] cinched = new byte[nEvents][nParameters][];
        if (variable) {
            sizes = this.sizing.getByteSizes();
        } else {
            size = this.sizing.getByteSize();
        }
        int position = 0;
        for (int event = 0; event < nEvents; ++event) {
            int parameter = 0;
            int used = 0;
            while (parameter < nParameters) {
                if (variable) {
                    size = sizes[parameter];
                }
                if (size == 0) {
                    StringBuffer buffer = new StringBuffer();
                    used = 0;
                    try {
                        char character;
                        while (CFCSListModeData.isDelimiter(character = (char)bytes[position + used++])) {
                        }
                        do {
                            buffer.append(character);
                        } while (!CFCSListModeData.isDelimiter(character = (char)bytes[position + used++]));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    cinched[event][parameter] = buffer.toString().getBytes();
                } else {
                    byte[] byArray = new byte[size];
                    cinched[event][parameter] = byArray;
                    byte[] cinch = byArray;
                    used = size;
                    System.arraycopy(bytes, position, cinch, 0, used);
                }
                ++parameter;
                position += used;
            }
        }
        return cinched;
    }

    @Override
    public final void setBytes(byte[] bytes) {
        super.setBytes(bytes);
        int events = this.getCount();
        for (int event = 0; event < events; ++event) {
            try {
                this.datatype.readData(event, this.cinched[event]);
                continue;
            }
            catch (IndexOutOfBoundsException exception) {
                throw new CFCSError(-7, event);
            }
        }
    }

    @Override
    public final byte[] getBytes() {
        int count = this.parameters.getCount();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            DataOutputStream stream = new DataOutputStream(buffer);
            int events = this.getCount();
            for (int event = 0; event < events; ++event) {
                try {
                    this.datatype.writeData(event, count, stream);
                    continue;
                }
                catch (IndexOutOfBoundsException exception) {
                    throw new CFCSError(-7, event);
                }
            }
            stream.close();
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
        byte[] bytes = buffer.toByteArray();
        return this.sizing.isPackedData() ? this.packBytes(bytes) : bytes;
    }

    private int classesputeShift(int have, int need) {
        int range = Integer.MIN_VALUE;
        int limit = 1 << need * 8;
        int count = this.parameters.getCount();
        for (int i = 0; i < count; ++i) {
            range = Math.max(this.parameters.getParameter(i).getRange(), range);
        }
        range = Math.min(range, 1 << have * 8);
        int shift = 0;
        while (range > limit) {
            range >>= 2;
            ++shift;
        }
        return shift;
    }

    @Override
    protected final byte[] packBytes(byte[] bytes) {
        int[] sizes = this.sizing.getSizes();
        int[] byteSizes = this.sizing.getByteSizes();
        int[] masks = this.sizing.getFieldMasks();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int current = 0;
        int valid = 0;
        int count = this.parameters.getCount();
        long accumulator = 0L;
        try {
            DataOutputStream stream = new DataOutputStream(buffer);
            int events = this.getCount();
            for (int event = 0; event < events; ++event) {
                for (int parameter = 0; parameter < count; ++parameter) {
                    int datum = 0;
                    int size = sizes[parameter];
                    int nBytes = byteSizes[parameter];
                    for (int i = 0; i < nBytes; ++i) {
                        datum = datum << 8 | bytes[current++] & 0xFF;
                    }
                    accumulator = accumulator << size | (long)(datum & masks[parameter]);
                    valid += size;
                    while (valid > 8) {
                        stream.write((int)(accumulator >>> (valid -= 8) & 0xFFL));
                        accumulator &= (long)((1 << valid) - 1);
                    }
                }
            }
            if (valid > 0) {
                stream.write((int)(accumulator << 8 - valid));
            }
            stream.close();
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
        return buffer.toByteArray();
    }

    @Override
    protected final byte[] unpackBytes(byte[] bytes) {
        int[] swap = this.keywords.getByteSwapArray();
        boolean swapped = false;
        for (int i = 0; i < swap.length && !(swapped = swap[i] != JAVA_BYTESWAP_ARRAY[i]); ++i) {
        }
        if (swapped) {
            return CFCSListModeData.unpackSwappedBytes(bytes);
        }
        return this.unpackNativeBytes(bytes);
    }

    protected static final byte[] unpackSwappedBytes(byte[] bytes) {
        throw new CFCSError(-33);
    }

    protected final byte[] unpackNativeBytes(byte[] bytes) {
        int[] sizes = this.sizing.getSizes();
        int[] byteSizes = this.sizing.getByteSizes();
        int[] masks = this.sizing.getFieldMasks();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int current = 0;
        int valid = 0;
        int accumulator = 0;
        int count = this.parameters.getCount();
        try {
            DataOutputStream stream = new DataOutputStream(buffer);
            int events = this.getCount();
            for (int event = 0; event < events; ++event) {
                block8: for (int parameter = 0; parameter < count; ++parameter) {
                    int size = sizes[parameter];
                    while (valid < size) {
                        accumulator = accumulator << 8 | bytes[current++] & 0xFF;
                        valid += 8;
                    }
                    int datum = accumulator >>> (valid -= size) & masks[parameter];
                    accumulator &= (1 << valid) - 1;
                    switch (byteSizes[parameter]) {
                        case 1: {
                            stream.write(datum);
                            continue block8;
                        }
                        case 2: {
                            stream.writeShort(datum);
                            continue block8;
                        }
                        case 4: {
                            stream.writeInt(datum);
                            continue block8;
                        }
                        default: {
                            throw new CFCSError(-33);
                        }
                    }
                }
            }
            stream.close();
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
        return buffer.toByteArray();
    }

    public final void getEvent(int index, byte[] array) {
        try {
            this.datatype.getData(index, array);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-7, index);
        }
        catch (CFCSDataSizeError exception) {
            short[] event = new short[array.length];
            int shift = this.classesputeShift(2, 1);
            this.getEvent(index, event);
            for (int i = 0; i < event.length; ++i) {
                array[i] = (byte)(event[i] >>> shift);
            }
        }
    }

    public final void setEvent(int index, byte[] array) {
        try {
            this.datatype.setData(index, array);
        }
        catch (CFCSDataScaleError exception) {
            double[] event = new double[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).channelToScale(array[i]);
            }
            this.setEvent(index, event);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-8, index);
        }
    }

    public final void addEvent(byte[] array) {
        try {
            this.datatype.addData(array);
        }
        catch (CFCSDataScaleError exception) {
            double[] event = new double[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).channelToScale(array[i]);
            }
            this.addEvent(event);
        }
        this.addCount(1);
    }

    public final void getEvent(int index, short[] array) {
        try {
            this.datatype.getData(index, array);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-7, index);
        }
        catch (CFCSDataSizeError exception) {
            int[] event = new int[array.length];
            int shift = this.classesputeShift(4, 2);
            this.getEvent(index, event);
            for (int i = 0; i < event.length; ++i) {
                array[i] = (short)(event[i] >>> shift);
            }
        }
    }

    public final void setEvent(int index, short[] array) {
        try {
            this.datatype.setData(index, array);
        }
        catch (CFCSDataScaleError exception) {
            double[] event = new double[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).channelToScale(array[i]);
            }
            this.setEvent(index, event);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-8, index);
        }
    }

    public final void addEvent(short[] array) {
        try {
            this.datatype.addData(array);
        }
        catch (CFCSDataScaleError exception) {
            double[] event = new double[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).channelToScale(array[i]);
            }
            this.addEvent(event);
        }
        this.addCount(1);
    }

    public final void getEvent(int index, int[] array) {
        try {
            this.datatype.getData(index, array);
            for (int i = 0; i < array.length; ++i) {
                array[i] = (int)this.parameters.getParameter(i).channelToScale(array[i]);
            }
        }
        catch (CFCSDataScaleError exception) {
            double[] event = new double[array.length];
            this.getEvent(index, event);
            for (int i = 0; i < event.length; ++i) {
                array[i] = this.parameters.getParameter(i).scaleToChannel(event[i]);
            }
        }
        catch (CFCSDataSizeError exception) {
            throw new CFCSError(-33);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-7, index);
        }
    }

    public final void setEvent(int index, int[] array) {
        try {
            this.datatype.setData(index, array);
        }
        catch (CFCSDataScaleError exception) {
            double[] event = new double[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).channelToScale(array[i]);
            }
            this.setEvent(index, event);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-8, index);
        }
    }

    public final void addEvent(int[] array) {
        try {
            this.datatype.addData(array);
        }
        catch (CFCSDataScaleError exception) {
            double[] event = new double[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).channelToScale(array[i]);
            }
            this.addEvent(event);
        }
        this.addCount(1);
    }

    public final void getEvent(int index, float[] array) {
        try {
            this.datatype.getData(index, array);
        }
        catch (CFCSDataChannelError exception) {
            int[] event = new int[array.length];
            try {
                this.datatype.getData(index, event);
            }
            catch (CFCSDataSizeError e) {
                throw new CFCSError(-33);
            }
            for (int i = 0; i < event.length; ++i) {
                array[i] = (float)this.parameters.getParameter(i).channelToScale(event[i]);
            }
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-7, index);
        }
    }

    public final void setEvent(int index, float[] array) {
        try {
            this.datatype.setData(index, array);
        }
        catch (CFCSDataChannelError exception) {
            int[] event = new int[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).scaleToChannel(array[i]);
            }
            this.setEvent(index, event);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-8, index);
        }
    }

    public final void addEvent(float[] array) {
        try {
            this.datatype.addData(array);
        }
        catch (CFCSDataChannelError exception) {
            int[] event = new int[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).scaleToChannel(array[i]);
            }
            this.addEvent(event);
        }
        this.addCount(1);
    }

    public final void getEvent(int index, double[] array) {
        try {
            this.datatype.getData(index, array);
        }
        catch (CFCSDataChannelError exception) {
            int[] event = new int[array.length];
            try {
                this.datatype.getData(index, event);
            }
            catch (CFCSDataSizeError e) {
                throw new CFCSError(-33);
            }
            for (int i = 0; i < event.length; ++i) {
                array[i] = this.parameters.getParameter(i).channelToScale(event[i]);
            }
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-7, index);
        }
    }

    public final void setEvent(int index, double[] array) {
        try {
            this.datatype.setData(index, array);
        }
        catch (CFCSDataChannelError exception) {
            int[] event = new int[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).scaleToChannel(array[i]);
            }
            this.setEvent(index, event);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-8, index);
        }
    }

    public final void addEvent(double[] array) {
        try {
            this.datatype.addData(array);
        }
        catch (CFCSDataChannelError exception) {
            int[] event = new int[array.length];
            for (int i = 0; i < event.length; ++i) {
                event[i] = this.parameters.getParameter(i).scaleToChannel(array[i]);
            }
            this.addEvent(event);
        }
        this.addCount(1);
    }

    public final void getEvents(int startIndex, int endIndex, int[][] table) {
        for (int index = startIndex; index <= endIndex; ++index) {
            this.getEvent(index, table[index]);
        }
    }

    public final void setEvents(int startIndex, int endIndex, int[][] table) {
        for (int index = startIndex; index <= endIndex; ++index) {
            this.setEvent(index, table[index]);
        }
    }

    public final void getEvent(int event, int nBytes, byte[][] table) {
        int count = this.parameters.getCount();
        if (table.length < count) {
            throw new CFCSError(-35, table.length);
        }
        for (int parameter = 0; parameter < count; ++parameter) {
            int i;
            byte[] bytes = table[parameter];
            if (bytes.length < nBytes) {
                throw new CFCSError(-35, bytes.length);
            }
            byte[] cinch = this.cinched[event][parameter];
            int length = cinch.length;
            int limit = nBytes - length;
            for (i = 0; i < limit; ++i) {
                bytes[i] = 0;
            }
            for (i = 0; i < length; ++i) {
                bytes[limit + i] = cinch[i];
            }
        }
    }

    public static final void setEvent(int index, int nBytes, byte[][] table) {
        throw new CFCSError(-33);
    }
}

