/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSAbstractParameter;
import org.flowcyt.cfcs.CFCSError;

public final class CFCSParameter
extends CFCSAbstractParameter {
    private int fieldSize = Integer.MIN_VALUE;
    private int lambda = Integer.MIN_VALUE;
    private double power = Double.NaN;
    private double gain = Double.NaN;
    private static final double LOG10 = Math.log(10.0);
    static final int FIELDSIZE_FREE_FORMAT = 0;
    static final String FIELDSIZE_FREE_FORMAT_STRING = "*";

    public final int getFieldSize() {
        if (CFCSParameter.isNotSet(this.fieldSize)) {
            throw new CFCSError(7, "FieldSize");
        }
        return this.fieldSize;
    }

    public final void setFieldSize(int fieldSize) {
        if (fieldSize != 0 && fieldSize < 1) {
            throw new CFCSError(-20, fieldSize);
        }
        this.fieldSize = fieldSize;
    }

    public final String getFieldSizeString() {
        if (this.fieldSize == 0) {
            return FIELDSIZE_FREE_FORMAT_STRING;
        }
        return Integer.toString(this.getFieldSize());
    }

    public final void setFieldSizeString(String fieldSize) {
        if (fieldSize.equalsIgnoreCase(FIELDSIZE_FREE_FORMAT_STRING)) {
            this.setFieldSize(0);
        } else {
            try {
                this.setFieldSize(new Integer(fieldSize));
            }
            catch (NumberFormatException exception) {
                throw new CFCSError(-19, (Throwable)exception);
            }
        }
    }

    public final double getGain() {
        if (CFCSParameter.isNotSet(this.gain)) {
            throw new CFCSError(7, "Gain");
        }
        return this.gain;
    }

    public final void setGain(double gain) {
        this.gain = gain;
    }

    public final int getExcitationWavelength() {
        if (CFCSParameter.isNotSet(this.lambda)) {
            throw new CFCSError(7, "ExcitationWavelength");
        }
        return this.lambda;
    }

    public final void setExcitationWavelength(int lambda) {
        if (lambda < 0) {
            throw new CFCSError(-20, lambda);
        }
        this.lambda = lambda;
    }

    public final double getLaserPower() {
        if (CFCSParameter.isNotSet(this.power)) {
            throw new CFCSError(7, "LaserPower");
        }
        return this.power;
    }

    public final void setLaserPower(double power) {
        if (power < 0.0) {
            throw new CFCSError(-20, power);
        }
        this.power = power;
    }

    @Override
    public final void setLogDecades(double decades) {
        if (decades == 0.0 && CFCSParameter.isSet(this.gain) && this.gain == 0.0) {
            throw new CFCSError(-21, "Gain");
        }
        super.setLogDecades(decades);
    }

    public final int scaleToChannel(double scale) {
        double channel;
        double decades = this.getLogDecades();
        if (decades > 0.0) {
            double offset = this.getOffset();
            if (offset > 0.0) {
                scale /= offset;
            }
            channel = Math.log(scale) / LOG10 * ((double)this.getRange() / decades);
        } else {
            channel = CFCSParameter.isSet(this.gain) && this.gain > 0.0 ? scale * this.gain : scale;
        }
        return Math.round((float)channel);
    }

    public final double channelToScale(int channel) {
        double decades = this.getLogDecades();
        if (decades > 0.0) {
            double scale = Math.pow(10.0, (double)channel * decades / (double)this.getRange());
            double offset = this.getOffset();
            if (offset > 0.0) {
                return scale * offset;
            }
            return scale;
        }
        return CFCSParameter.isSet(this.gain) && this.gain > 0.0 ? (double)channel / this.gain : (double)channel;
    }
}

