/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;

public final class CFCSSystem
implements CFCSErrorCodes {
    private final List datasets = new ArrayList();
    private URLConnection connection;
    private FileOutputStream fos;
    private static final String CFCS_VERSION = "0.32 (alpha) / API v01.10";
    private static final byte PAD_BYTE = 32;
    static final char PAD_CHAR = ' ';
    static final char VALUE_SEPARATOR_CHAR = ',';
    static final int BITSPERBYTE = 8;

    public static final String getVersion() {
        return CFCS_VERSION;
    }

    private void setFileKeyword(CFCSDataSet dataset) {
        URL url = this.connection.getURL();
        CFCSKeywords keywords = dataset.getKeywords();
        keywords.addSystemKeyword(new CFCSKeyword("$FIL", url.getFile()));
    }

    public final void open(String URL2) {
        URL url;
        try {
            url = new URL(URL2);
        }
        catch (MalformedURLException exception) {
            throw new CFCSError(-2, exception.getMessage());
        }
        this.open(url);
    }

    public final void open(URL url) {
        try {
            InputStream stream = url.openStream();
            this.open(stream);
        }
        catch (IOException e) {
            throw new CFCSError(-14, e.getMessage());
        }
    }

    public final void open(InputStream stream) {
        try {
            long start = 0L;
            SentientInputStream sentient = new SentientInputStream(stream);
            do {
                sentient.resetFilePointer();
                CFCSDataSet dataset = new CFCSDataSet(sentient);
                this.datasets.add(dataset);
                CFCSKeywords keywords = dataset.getKeywords();
                try {
                    long offset;
                    CFCSKeyword nextdata = keywords.getKeyword("$NEXTDATA");
                    start = nextdata.getKeywordIntegerValue();
                    if (start <= 0L || (offset = sentient.getFilePointer()) >= start) continue;
                    sentient.skip(start - offset);
                }
                catch (CFCSError error) {
                    break;
                }
            } while (start > 0L);
            stream.close();
        }
        catch (IOException exception) {
            throw new CFCSError(-14, exception.getMessage());
        }
    }

    public final void create(String URL2) {
        URL url;
        try {
            url = new URL(URL2);
        }
        catch (MalformedURLException exception) {
            throw new CFCSError(-2, exception.getMessage());
        }
        try {
            this.connection = url.openConnection();
        }
        catch (IOException exception) {
            throw new CFCSError(-5, exception.getMessage());
        }
    }

    public final void createLocal(String path) {
        File file = new File(path);
        try {
            this.fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public final void modify(String source, String destination) {
        this.open(source);
        this.create(destination);
    }

    public final int getCount() {
        return this.datasets.size();
    }

    public final CFCSDataSet getDataSet(int setIdx) {
        if (setIdx < 0 || setIdx > this.datasets.size() - 1) {
            throw new CFCSError(-29);
        }
        return (CFCSDataSet)this.datasets.get(setIdx);
    }

    public final CFCSDataSet createDataSet(int mode) {
        return this.createDataSet(mode, 4);
    }

    public final CFCSDataSet createDataSet(int mode, int type) {
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new CFCSError(-29, mode);
        }
        CFCSDataSet dataset = new CFCSDataSet(mode, type);
        this.datasets.add(dataset);
        this.setFileKeyword(dataset);
        return dataset;
    }

    public final CFCSDataSet createDataSet(CFCSDataSet source) {
        CFCSDataSet dataset = new CFCSDataSet(source);
        this.datasets.add(dataset);
        this.setFileKeyword(dataset);
        return dataset;
    }

    public final void deleteDataSet(int setIdx) {
        if (setIdx < 0 || setIdx > this.datasets.size() - 1) {
            throw new CFCSError(-29, setIdx);
        }
        this.datasets.remove(setIdx);
    }

    public final void close() {
        if (this.connection != null) {
            URL url = this.connection.getURL();
            String path = url.getPath();
            try {
                OutputStream stream = "file".equalsIgnoreCase(url.getProtocol()) ? new FileOutputStream(path) : this.connection.getOutputStream();
                SentientOutputStream sentient = new SentientOutputStream(stream);
                long next = 0L;
                int count = this.getCount();
                for (int i = 0; i < count; ++i) {
                    sentient.resetFilePointer();
                    CFCSDataSet dataset = this.getDataSet(i);
                    dataset.writeDataSet(sentient, i < count - 1 ? next : -1L);
                    next += sentient.getFilePointer();
                }
                sentient.close();
            }
            catch (IOException exception) {
                throw new CFCSError(-5, exception.getMessage());
            }
        }
    }

    public final void closeLocal() {
        if (this.fos != null) {
            try {
                SentientOutputStream sentient = new SentientOutputStream(this.fos);
                long next = 0L;
                int count = this.getCount();
                for (int i = 0; i < count; ++i) {
                    sentient.resetFilePointer();
                    CFCSDataSet dataset = this.getDataSet(i);
                    dataset.writeDataSet(sentient, i < count - 1 ? next : -1L);
                    next += sentient.getFilePointer();
                }
                sentient.close();
            }
            catch (IOException exception) {
                throw new CFCSError(-5, exception.getMessage());
            }
        }
    }

    static final class SentientOutputStream
    extends BufferedOutputStream {
        protected long filePointer = 0L;

        final long getFilePointer() {
            return this.filePointer;
        }

        final void resetFilePointer() {
            this.filePointer = 0L;
        }

        public SentientOutputStream(OutputStream out) {
            super(out);
        }

        public SentientOutputStream(OutputStream out, int size) {
            super(out, size);
        }

        @Override
        public final void write(int b) throws IOException {
            super.write(b);
            ++this.filePointer;
        }

        @Override
        public final void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.filePointer += (long)b.length;
        }

        public final void skip(long n) throws IOException {
            int i = 0;
            while ((long)i < n) {
                this.write(32);
                ++i;
            }
        }
    }

    static final class SentientInputStream
    extends BufferedInputStream {
        protected long filePointer = 0L;
        protected CRC16_CCITT crc16 = new CRC16_CCITT();

        public int getCRC16() {
            return this.crc16.value;
        }

        final long getFilePointer() {
            return this.filePointer;
        }

        final void resetFilePointer() {
            this.filePointer = 0L;
            this.crc16.reset();
        }

        final void resetCRC() {
            this.crc16.reset();
        }

        public SentientInputStream(InputStream in) {
            super(in);
        }

        public SentientInputStream(InputStream in, int size) {
            super(in, size);
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read() throws IOException {
            int result = super.read();
            if (result != -1) {
                ++this.filePointer;
                this.crc16.update((byte)result);
            }
            return result;
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            int bytes = super.read(b, off, len);
            this.filePointer += (long)bytes;
            for (int i = 0; i < bytes; ++i) {
                this.crc16.update(b[i]);
            }
            return bytes;
        }

        @Override
        public final long skip(long n) throws IOException {
            long skipped = 0L;
            int i = 0;
            while ((long)i < n) {
                if (this.read() != -1) {
                    ++skipped;
                }
                ++i;
            }
            return skipped;
        }
    }

    public static class CRC16_CCITT {
        private int work = 65535;
        public int value = 65535;
        private static final int poly = 4129;
        private static final int initvalue = 65535;
        private static final boolean bReverseBits = true;
        private static int[] crcTable = new int[256];

        public void update(byte b) {
            byte bx = CRC16_CCITT.ReverseBits(b);
            this.value = this.work = (crcTable[(bx ^ this.work >>> 8) & 0xFF] ^ this.work << 8) & 0xFFFF;
        }

        public void reset() {
            this.value = 65535;
            this.work = 65535;
        }

        public String toString() {
            return new Integer(this.work).toString();
        }

        private static byte ReverseBits(byte b) {
            return (byte)((b & 1) << 7 | (b & 2) << 5 | (b & 4) << 3 | (b & 8) << 1 | (b & 0x10) >> 1 | (b & 0x20) >> 3 | (b & 0x40) >> 5 | (b & 0xFFFFFF80) >> 7);
        }

        static {
            for (int i = 0; i < 256; ++i) {
                int fcs = 0;
                int d = i << 8;
                for (int k = 0; k < 8; ++k) {
                    fcs = ((fcs ^ d) & 0x8000) != 0 ? fcs << 1 ^ 0x1021 : (fcs <<= 1);
                    d <<= 1;
                    fcs &= 0xFFFF;
                }
                CRC16_CCITT.crcTable[i] = fcs;
            }
        }
    }
}

