/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSAbstractData;
import org.flowcyt.cfcs.CFCSDataSizeError;
import org.flowcyt.cfcs.CFCSDataSizing;
import org.flowcyt.cfcs.CFCSDatatype;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSKeywords;

public final class CFCSUncorrelatedData
extends CFCSAbstractData
implements CFCSErrorCodes {
    CFCSUncorrelatedData(CFCSDatatype datatype, CFCSKeywords keywords) {
        super(3, datatype, keywords);
        this.sizing = new CFCSDataSizing(keywords){

            @Override
            public int getSizeVariability() {
                return 2;
            }
        };
        datatype.setSizingObject(this.sizing);
    }

    @Override
    protected final byte[][][] cinchBytes(byte[] bytes) {
        int[] sizes = null;
        int size = 0;
        int nParameters = this.parameters.getCount();
        boolean variable = this.sizing.getSizeVariability() != 0;
        byte[][][] cinched = new byte[nParameters][][];
        if (variable) {
            sizes = this.sizing.getByteSizes();
        } else {
            size = this.sizing.getByteSize();
        }
        int position = 0;
        for (int parameter = 0; parameter < nParameters; ++parameter) {
            int range = this.parameters.getParameter(parameter).getRange();
            cinched[parameter] = new byte[range][];
            if (variable) {
                size = sizes[parameter];
            }
            int bin = 0;
            while (bin < range) {
                byte[] byArray = new byte[size];
                cinched[parameter][bin] = byArray;
                byte[] cinch = byArray;
                System.arraycopy(bytes, position, cinch, 0, size);
                ++bin;
                position += size;
            }
        }
        return cinched;
    }

    @Override
    public final byte[] getBytes() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            DataOutputStream stream = new DataOutputStream(buffer);
            int count = this.parameters.getCount();
            for (int parameter = 0; parameter < count; ++parameter) {
                int range = this.parameters.getParameter(parameter).getRange();
                try {
                    this.datatype.writeData(parameter, range, stream);
                    continue;
                }
                catch (IndexOutOfBoundsException exception) {
                    throw new CFCSError(-8, parameter);
                }
            }
            stream.close();
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
        byte[] bytes = buffer.toByteArray();
        return this.sizing.isPackedData() ? this.packBytes(bytes) : bytes;
    }

    @Override
    public final void setBytes(byte[] bytes) {
        super.setBytes(bytes);
        int count = this.parameters.getCount();
        for (int parameter = 0; parameter < count; ++parameter) {
            try {
                this.datatype.readData(parameter, this.cinched[parameter]);
                continue;
            }
            catch (IndexOutOfBoundsException exception) {
                throw new CFCSError(-8, parameter);
            }
        }
    }

    public final void getArray(int index, int[] array) {
        try {
            this.datatype.getData(index, array);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-8, index);
        }
        catch (CFCSDataSizeError exception) {
            throw new CFCSError(-33);
        }
    }

    public final void setArray(int index, int[] array) {
        try {
            this.datatype.setData(index, array);
        }
        catch (IndexOutOfBoundsException exception) {
            throw new CFCSError(-8, index);
        }
        catch (CFCSDataSizeError exception) {
            throw new CFCSError(-33);
        }
    }

    public final void addArray(int[] array) {
        try {
            this.datatype.addData(array);
        }
        catch (CFCSDataSizeError exception) {
            throw new CFCSError(-33);
        }
        int events = 0;
        for (int i = 0; i < array.length; ++i) {
            events += array[i];
        }
        this.setCount(events);
    }

    public final void getArray(int parameter, int nBytes, byte[][] table) {
        int range = this.parameters.getParameter(parameter).getRange();
        if (table.length < range) {
            throw new CFCSError(-35, table.length);
        }
        for (int bin = 0; bin < range; ++bin) {
            int i;
            byte[] bytes = table[bin];
            if (bytes.length < nBytes) {
                throw new CFCSError(-35, bytes.length);
            }
            byte[] cinch = this.cinched[parameter][bin];
            int length = cinch.length;
            int limit = nBytes - length;
            for (i = 0; i < limit; ++i) {
                bytes[i] = 0;
            }
            for (i = 0; i < length; ++i) {
                bytes[limit + i] = cinch[i];
            }
        }
    }

    public static final void setArray(int index, int nBytes, byte[][] table) {
        throw new CFCSError(-33);
    }
}

