/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;

public class CombineListmode {
    private static final int OUTPUT = 0;
    private static final int INPUT = 1;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static boolean confirm(String prompt) {
        int input;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(prompt + " (Y/N): ");
        System.out.flush();
        try {
            input = reader.readLine().trim().charAt(0);
        }
        catch (Exception exception) {
            input = 78;
        }
        return input == 121 || input == 89;
    }

    public static boolean classespareParameter(String name, String output, String input) {
        if (!output.equals(input)) {
            String warning = name + " differs (\"" + output + "\" vs. \"" + input + "\") continue?";
            return CombineListmode.confirm(warning);
        }
        return true;
    }

    public static boolean classespareParameter(String name, int output, int input) {
        if (output != input) {
            String warning = name + " differs (" + output + " vs. " + input + ") continue?";
            return CombineListmode.confirm(warning);
        }
        return true;
    }

    public static boolean classespareParameter(String name, double output, double input) {
        if (output != input) {
            String warning = name + " differs (" + output + " vs. " + input + ") continue?";
            return CombineListmode.confirm(warning);
        }
        return true;
    }

    public static boolean classespareParameters(CFCSParameters destination, CFCSParameters source) {
        int count = destination.getCount();
        if (count != source.getCount()) {
            System.err.println("Parameter count differs, can't continue!");
            return false;
        }
        for (int i = 0; i < count; ++i) {
            CFCSParameter input = source.getParameter(i);
            CFCSParameter output = destination.getParameter(i);
            try {
                if (!CombineListmode.classespareParameter("Full Name", output.getFullName(), input.getFullName())) {
                    return false;
                }
            }
            catch (CFCSError error) {
                // empty catch block
            }
            try {
                if (!CombineListmode.classespareParameter("Short Name", output.getShortName(), input.getShortName())) {
                    return false;
                }
            }
            catch (CFCSError error) {
                // empty catch block
            }
            try {
                if (!CombineListmode.classespareParameter("Gain", output.getGain(), input.getGain())) {
                    return false;
                }
            }
            catch (CFCSError error) {
                // empty catch block
            }
            try {
                if (!CombineListmode.classespareParameter("Field Size", output.getFieldSize(), input.getFieldSize())) {
                    return false;
                }
                if (!CombineListmode.classespareParameter("Range Size", output.getRange(), input.getRange())) {
                    return false;
                }
                if (!CombineListmode.classespareParameter("Log Decade", output.getLogDecades(), input.getLogDecades())) {
                    return false;
                }
                if (CombineListmode.classespareParameter("Offset", output.getOffset(), input.getOffset())) continue;
                return false;
            }
            catch (CFCSError error) {
                System.err.println("Required parameter missing, can't continue!");
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        CFCSSystem writeSystem;
        block13: {
            writeSystem = new CFCSSystem();
            try {
                writeSystem.create(args[0]);
            }
            catch (CFCSError error) {
                if (CombineListmode.failIfError(error) == 0) break block13;
                System.exit(1);
            }
        }
        for (int file = 1; file < args.length; ++file) {
            CFCSSystem readSystem;
            block14: {
                readSystem = new CFCSSystem();
                try {
                    readSystem.open(args[file]);
                }
                catch (CFCSError error) {
                    if (CombineListmode.failIfError(error) == 0) break block14;
                    System.exit(1);
                }
            }
            int nDataSets = readSystem.getCount();
            block8: for (int set = 0; set < nDataSets; ++set) {
                CFCSDataSet readSet = readSystem.getDataSet(set);
                CFCSParameters readParam = readSet.getParameters();
                CFCSData readData = readSet.getData();
                int type = readData.getType();
                CFCSDataSet writeSet = null;
                if (set >= writeSystem.getCount()) {
                    writeSet = writeSystem.createDataSet(readSet);
                } else {
                    writeSet = writeSystem.getDataSet(set);
                    CFCSParameters writeParam = writeSet.getParameters();
                    if (!CombineListmode.classespareParameters(writeParam, readParam)) {
                        System.exit(1);
                    }
                }
                CFCSData writeData = writeSet.getData();
                switch (type) {
                    case 1: {
                        int[] event = new int[readParam.getCount()];
                        int nEvents = ((CFCSListModeData)readData).getCount();
                        for (int i = 0; i < nEvents; ++i) {
                            ((CFCSListModeData)readData).getEvent(i, event);
                            ((CFCSListModeData)writeData).addEvent(event);
                        }
                        continue block8;
                    }
                    default: {
                        System.exit(1);
                    }
                }
            }
            readSystem.close();
        }
        writeSystem.close();
    }
}

