/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;

public class GateChannels {
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;
    private static final int LIMIT = 100;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static void main(String[] argv) {
        CFCSSystem writeSystem;
        CFCSSystem readSystem;
        block7: {
            block6: {
                readSystem = new CFCSSystem();
                try {
                    readSystem.open(argv[0]);
                }
                catch (CFCSError error) {
                    if (GateChannels.failIfError(error) == 0) break block6;
                    System.exit(1);
                }
            }
            writeSystem = new CFCSSystem();
            try {
                writeSystem.create(argv[1]);
            }
            catch (CFCSError error) {
                if (GateChannels.failIfError(error) == 0) break block7;
                System.exit(1);
            }
        }
        int nDataSets = readSystem.getCount();
        for (int iset = 0; iset < nDataSets; ++iset) {
            CFCSDataSet readSet = readSystem.getDataSet(iset);
            CFCSData readData = readSet.getData();
            int readDataType = readData.getType();
            if (readDataType != 1) continue;
            CFCSDataSet writeSet = writeSystem.createDataSet(readSet);
            CFCSData writeData = writeSet.getData();
            CFCSListModeData readList = (CFCSListModeData)readData;
            CFCSListModeData writeList = (CFCSListModeData)writeData;
            CFCSParameters paramList = readSet.getParameters();
            short[] event = new short[paramList.getCount()];
            int nEvents = readList.getCount();
            for (int idx = 0; idx < nEvents; ++idx) {
                readList.getEvent(idx, event);
                if (event[0] >= 100) continue;
                writeList.addEvent(event);
            }
        }
        readSystem.close();
        writeSystem.close();
    }
}

