/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSCorrelatedData;
import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;
import org.flowcyt.cfcs.CFCSUncorrelatedData;

public class IntegerToAscii {
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static void main(String[] argv) {
        CFCSSystem writeSystem;
        CFCSSystem readSystem;
        block20: {
            block19: {
                readSystem = new CFCSSystem();
                try {
                    readSystem.open(argv[0]);
                }
                catch (CFCSError error) {
                    if (IntegerToAscii.failIfError(error) == 0) break block19;
                    System.exit(1);
                }
            }
            writeSystem = new CFCSSystem();
            try {
                writeSystem.create(argv[1]);
            }
            catch (CFCSError error) {
                if (IntegerToAscii.failIfError(error) == 0) break block20;
                System.exit(1);
            }
        }
        int nDataSets = readSystem.getCount();
        for (int set = 0; set < nDataSets; ++set) {
            int i;
            CFCSDataSet readSet = readSystem.getDataSet(set);
            CFCSKeywords readKeywords = readSet.getKeywords();
            CFCSParameters readParam = readSet.getParameters();
            CFCSData readData = readSet.getData();
            int type = readData.getType();
            CFCSDataSet writeSet = writeSystem.createDataSet(type, 1);
            CFCSKeywords writeKeywords = writeSet.getKeywords();
            CFCSParameters writeParam = writeSet.getParameters();
            CFCSData writeData = writeSet.getData();
            int count = readParam.getCount();
            for (i = 0; i < count; ++i) {
                CFCSParameter parameter = readParam.getParameter(i);
                parameter.setFieldSize(0);
                writeParam.addParameter(parameter);
            }
            switch (type) {
                case 1: {
                    int[] event = new int[readParam.getCount()];
                    int nEvents = ((CFCSListModeData)readData).getCount();
                    for (int i2 = 0; i2 < nEvents; ++i2) {
                        ((CFCSListModeData)readData).getEvent(i2, event);
                        ((CFCSListModeData)writeData).addEvent(event);
                    }
                    break;
                }
                case 3: {
                    int nParams = writeParam.getCount();
                    for (int i3 = 0; i3 < nParams; ++i3) {
                        int[] array = new int[writeParam.getParameter(i3).getRange()];
                        ((CFCSUncorrelatedData)readData).getArray(i3, array);
                        ((CFCSUncorrelatedData)writeData).addArray(array);
                    }
                    break;
                }
                case 2: {
                    int[][] table = new int[writeParam.getParameter(1).getRange()][writeParam.getParameter(0).getRange()];
                    ((CFCSCorrelatedData)readData).getArray(table);
                    ((CFCSCorrelatedData)writeData).setArray(table);
                }
            }
            count = readKeywords.getCount();
            for (i = 0; i < count; ++i) {
                CFCSKeyword keyword = readKeywords.getKeyword(i);
                try {
                    writeKeywords.getKeyword(keyword.getKeywordName());
                    continue;
                }
                catch (CFCSError error) {
                    if (error.errorNumber == -16) {
                        try {
                            writeKeywords.addKeyword(keyword);
                        }
                        catch (CFCSError exception) {}
                        continue;
                    }
                    if (IntegerToAscii.failIfError(error) == 0) continue;
                    System.exit(1);
                }
            }
        }
        readSystem.close();
        writeSystem.close();
    }
}

