/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;

public class IntegerToDouble {
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;
    private static final int BITSPERDOUBLE = 64;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static void main(String[] argv) {
        CFCSSystem writeSystem;
        CFCSSystem readSystem;
        block17: {
            block16: {
                readSystem = new CFCSSystem();
                try {
                    readSystem.open(argv[0]);
                }
                catch (CFCSError error) {
                    if (IntegerToDouble.failIfError(error) == 0) break block16;
                    System.exit(1);
                }
            }
            writeSystem = new CFCSSystem();
            try {
                writeSystem.create(argv[1]);
            }
            catch (CFCSError error) {
                if (IntegerToDouble.failIfError(error) == 0) break block17;
                System.exit(1);
            }
        }
        int nDataSets = readSystem.getCount();
        for (int iset = 0; iset < nDataSets; ++iset) {
            int i;
            CFCSDataSet readSet = readSystem.getDataSet(iset);
            CFCSKeywords readKeywords = readSet.getKeywords();
            CFCSParameters readParam = readSet.getParameters();
            CFCSData readData = readSet.getData();
            int type = readData.getType();
            CFCSDataSet writeSet = writeSystem.createDataSet(type, 3);
            CFCSKeywords writeKeywords = writeSet.getKeywords();
            CFCSParameters writeParam = writeSet.getParameters();
            CFCSData writeData = writeSet.getData();
            int count = readParam.getCount();
            for (i = 0; i < count; ++i) {
                CFCSParameter parameter = readParam.getParameter(i);
                parameter.setFieldSize(64);
                writeParam.addParameter(parameter);
            }
            switch (type) {
                case 1: {
                    double[] event = new double[readParam.getCount()];
                    int nEvents = ((CFCSListModeData)readData).getCount();
                    for (int idx = 0; idx < nEvents; ++idx) {
                        ((CFCSListModeData)readData).getEvent(idx, event);
                        ((CFCSListModeData)writeData).addEvent(event);
                    }
                    break;
                }
                default: {
                    System.exit(1);
                }
            }
            count = readKeywords.getCount();
            for (i = 0; i < count; ++i) {
                CFCSKeyword keyword = readKeywords.getKeyword(i);
                try {
                    writeKeywords.getKeyword(keyword.getKeywordName());
                    continue;
                }
                catch (CFCSError error) {
                    if (error.errorNumber == -16) {
                        try {
                            writeKeywords.addKeyword(keyword);
                        }
                        catch (CFCSError exception) {}
                        continue;
                    }
                    if (IntegerToDouble.failIfError(error) == 0) continue;
                    System.exit(1);
                }
            }
        }
        readSystem.close();
        writeSystem.close();
    }
}

