/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSCorrelatedData;
import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;

public class ListModeToCorrelated {
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;
    private static final int PARM1 = 2;
    private static final int PARM2 = 3;
    private static final int BITSPERINT = 32;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static void main(String[] argv) {
        CFCSSystem write_system;
        int index_two;
        int index_one;
        CFCSSystem read_system;
        block9: {
            block8: {
                read_system = new CFCSSystem();
                index_one = 0;
                index_two = 1;
                if (argv.length > 2) {
                    index_one = new Integer(argv[2]) - 1;
                    if (argv.length > 3) {
                        index_two = new Integer(argv[3]) - 1;
                    }
                }
                try {
                    read_system.open(argv[0]);
                }
                catch (CFCSError error) {
                    if (ListModeToCorrelated.failIfError(error) == 0) break block8;
                    System.exit(1);
                }
            }
            write_system = new CFCSSystem();
            try {
                write_system.create(argv[1]);
            }
            catch (CFCSError error) {
                if (ListModeToCorrelated.failIfError(error) == 0) break block9;
                System.exit(1);
            }
        }
        int nDataSets = read_system.getCount();
        for (int iset = 0; iset < nDataSets; ++iset) {
            CFCSDataSet read_set = read_system.getDataSet(iset);
            CFCSData read_data = read_set.getData();
            if (read_data.getType() != 1) continue;
            CFCSDataSet write_set = write_system.createDataSet(2);
            CFCSData write_data = write_set.getData();
            CFCSListModeData read_list = (CFCSListModeData)read_data;
            CFCSCorrelatedData write_histogram = (CFCSCorrelatedData)write_data;
            CFCSParameters read_parameters = read_set.getParameters();
            CFCSParameters write_parameters = write_set.getParameters();
            CFCSParameter parameter_one = read_parameters.getParameter(index_one);
            CFCSParameter parameter_two = read_parameters.getParameter(index_two);
            int range_one = parameter_one.getRange();
            int range_two = parameter_two.getRange();
            parameter_one.setFieldSize(32);
            parameter_two.setFieldSize(32);
            write_parameters.addParameter(parameter_one);
            write_parameters.addParameter(parameter_two);
            int[][] histogram = new int[range_two][range_one];
            int[] event = new int[read_parameters.getCount()];
            int nEvents = read_list.getCount();
            for (int j = 0; j < nEvents; ++j) {
                read_list.getEvent(j, event);
                int[] nArray = histogram[event[index_two]];
                int n = event[index_one];
                nArray[n] = nArray[n] + 1;
            }
            write_histogram.setArray(histogram);
        }
        write_system.close();
        read_system.close();
    }
}

