/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;
import org.flowcyt.cfcs.CFCSUncorrelatedData;

public class ListModeToUncorrelated {
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;
    private static final int BITSPERINT = 32;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static void main(String[] argv) {
        CFCSSystem write_system;
        CFCSSystem read_system;
        block10: {
            block9: {
                read_system = new CFCSSystem();
                try {
                    read_system.open(argv[0]);
                }
                catch (CFCSError error) {
                    if (ListModeToUncorrelated.failIfError(error) == 0) break block9;
                    System.exit(1);
                }
            }
            write_system = new CFCSSystem();
            try {
                write_system.create(argv[1]);
            }
            catch (CFCSError error) {
                if (ListModeToUncorrelated.failIfError(error) == 0) break block10;
                System.exit(1);
            }
        }
        int nDataSets = read_system.getCount();
        for (int iset = 0; iset < nDataSets; ++iset) {
            CFCSDataSet read_set = read_system.getDataSet(iset);
            CFCSData read_data = read_set.getData();
            if (read_data.getType() != 1) continue;
            CFCSDataSet write_set = write_system.createDataSet(3);
            CFCSData write_data = write_set.getData();
            CFCSListModeData read_list = (CFCSListModeData)read_data;
            CFCSUncorrelatedData write_histogram = (CFCSUncorrelatedData)write_data;
            CFCSParameters read_parameters = read_set.getParameters();
            CFCSParameters write_parameters = write_set.getParameters();
            int count = read_parameters.getCount();
            int[][] histogram = new int[count][];
            for (int i = 0; i < count; ++i) {
                CFCSParameter parameter = read_parameters.getParameter(i);
                parameter.setFieldSize(32);
                write_parameters.addParameter(parameter);
                histogram[i] = new int[parameter.getRange()];
            }
            short[] event = new short[read_parameters.getCount()];
            int nEvents = read_list.getCount();
            for (int j = 0; j < nEvents; ++j) {
                read_list.getEvent(j, event);
                for (int i = 0; i < event.length; ++i) {
                    int[] nArray = histogram[i];
                    int n = event[i] & 0xFFFF;
                    nArray[n] = nArray[n] + 1;
                }
            }
            for (int i = 0; i < count; ++i) {
                write_histogram.addArray(histogram[i]);
            }
        }
        write_system.close();
        read_system.close();
    }
}

