/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.facejava.fcsdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.flowcyt.facejava.fcsdata.Event;
import org.flowcyt.facejava.fcsdata.Parameter;
import org.flowcyt.facejava.fcsdata.ParameterCollection;
import org.flowcyt.facejava.fcsdata.ParameterReference;
import org.flowcyt.facejava.fcsdata.exception.CircularParameterDependencyException;
import org.flowcyt.facejava.fcsdata.exception.DataRetrievalException;
import org.flowcyt.facejava.fcsdata.exception.DuplicateParameterReferenceException;
import org.flowcyt.facejava.fcsdata.exception.NoSuchParameterException;

public class DataRetriever {
    private List<ParameterCollection<?>> parameterCollections = new ArrayList();
    private Map<ParameterReference, Parameter> parameterCache;
    private List<Parameter> allParameters;

    public DataRetriever(List<? extends ParameterCollection<?>> parameterCollections) throws DuplicateParameterReferenceException, CircularParameterDependencyException {
        this(null, parameterCollections);
    }

    public DataRetriever(DataRetriever original, List<? extends ParameterCollection<?>> additionalParameterCollections) throws DuplicateParameterReferenceException, CircularParameterDependencyException {
        if (original != null) {
            this.parameterCollections.addAll(original.parameterCollections);
        }
        this.parameterCollections.addAll(additionalParameterCollections);
        this.allParameters = new ArrayList<Parameter>();
        for (ParameterCollection<?> paramColl : this.parameterCollections) {
            this.allParameters.addAll(paramColl);
        }
        this.parameterCache = new HashMap<ParameterReference, Parameter>(this.allParameters.size());
        Set<ParameterReference> duplicates = this.duplicateNameCheck();
        if (duplicates.size() > 0) {
            throw new DuplicateParameterReferenceException(duplicates);
        }
        this.dependencyCycleCheck();
    }

    public List<Parameter> getAllParameters() {
        return this.allParameters;
    }

    private Set<ParameterReference> duplicateNameCheck() {
        HashSet<ParameterReference> duplicates = new HashSet<ParameterReference>();
        for (int numBaseSets = 1; numBaseSets < this.parameterCollections.size(); ++numBaseSets) {
            HashSet<ParameterReference> allInBaseSets = new HashSet<ParameterReference>();
            for (int i = 0; i < numBaseSets; ++i) {
                allInBaseSets.addAll(this.parameterCollections.get(i).getParameterReferences());
            }
            allInBaseSets.retainAll(this.parameterCollections.get(numBaseSets).getParameterReferences());
            duplicates.addAll(allInBaseSets);
        }
        return duplicates;
    }

    private void dependencyCycleCheck() throws CircularParameterDependencyException {
        HashSet<Parameter> parametersToCheck = new HashSet<Parameter>(this.getAllParameters());
        while (!parametersToCheck.isEmpty()) {
            Stack<Parameter> cyclePath = new Stack<Parameter>();
            Parameter startParam = (Parameter)parametersToCheck.iterator().next();
            if (!this.dependencyCycleCheckHelper(startParam, cyclePath, parametersToCheck)) continue;
            Parameter cycleParam = cyclePath.peek();
            int firstOccurrence = cyclePath.indexOf(cycleParam);
            int lastOccurrence = cyclePath.lastIndexOf(cycleParam);
            throw new CircularParameterDependencyException(cyclePath.subList(firstOccurrence, lastOccurrence + 1));
        }
    }

    private boolean dependencyCycleCheckHelper(Parameter currentParam, Stack<Parameter> pathToCurrentParam, Set<Parameter> parametersToCheck) {
        if (pathToCurrentParam.contains(currentParam)) {
            pathToCurrentParam.push(currentParam);
            return true;
        }
        if (currentParam.getDependencies().size() > 0) {
            pathToCurrentParam.push(currentParam);
            for (ParameterReference dependencyReference : currentParam.getDependencies()) {
                try {
                    Parameter dependency = this.resolveReference(dependencyReference);
                    if (!parametersToCheck.contains(dependency) || !this.dependencyCycleCheckHelper(dependency, pathToCurrentParam, parametersToCheck)) continue;
                    return true;
                }
                catch (NoSuchParameterException e) {
                }
            }
            pathToCurrentParam.pop();
        }
        parametersToCheck.remove(currentParam);
        return false;
    }

    public Parameter resolveReference(ParameterReference parameterReference) throws NoSuchParameterException {
        ParameterCollection<?> paramColl;
        Parameter referencedParam = null;
        referencedParam = this.parameterCache.get(parameterReference);
        if (referencedParam != null) {
            return referencedParam;
        }
        Iterator<ParameterCollection<?>> i$ = this.parameterCollections.iterator();
        while (i$.hasNext() && (referencedParam = (paramColl = i$.next()).get(parameterReference)) == null) {
        }
        if (referencedParam == null) {
            throw new NoSuchParameterException(parameterReference);
        }
        this.parameterCache.put(parameterReference, referencedParam);
        return referencedParam;
    }

    public double getScale(ParameterReference parameterReference, Event ev) throws NoSuchParameterException, DataRetrievalException {
        Parameter referencedParam = this.resolveReference(parameterReference);
        return this.getScale(referencedParam, ev);
    }

    public double getScale(Parameter param, Event ev) throws DataRetrievalException {
        return param.getScale(ev, this);
    }
}

