/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.facejava.fcsdata.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowcyt.facejava.fcsdata.ParameterCollection;
import org.flowcyt.facejava.fcsdata.ParameterReference;
import org.flowcyt.facejava.fcsdata.exception.DuplicateParameterReferenceException;
import org.flowcyt.facejava.fcsdata.exception.InvalidParameterNumberException;
import org.flowcyt.facejava.fcsdata.impl.FcsParameter;

public class FcsParameterList
extends AbstractList<FcsParameter>
implements ParameterCollection<FcsParameter> {
    private Map<ParameterReference, FcsParameter> refToParamMap = new HashMap<ParameterReference, FcsParameter>();
    private List<FcsParameter> parameterList = new ArrayList<FcsParameter>();

    public FcsParameterList() {
    }

    public FcsParameterList(Collection<? extends FcsParameter> coll) throws DuplicateParameterReferenceException, InvalidParameterNumberException {
        this();
        ArrayList<? extends FcsParameter> sorted = new ArrayList<FcsParameter>(coll);
        Collections.sort(sorted, new Comparator<FcsParameter>(){

            @Override
            public int compare(FcsParameter o1, FcsParameter o2) {
                return o1.getParameterNumber() - o2.getParameterNumber();
            }
        });
        int i = 1;
        for (FcsParameter fcsParameter : sorted) {
            if (fcsParameter.getParameterNumber() != i) {
                throw new InvalidParameterNumberException(this, fcsParameter.getParameterNumber());
            }
            this.parameterList.add(fcsParameter);
            ParameterReference reference = fcsParameter.getReference();
            if (this.refToParamMap.containsKey(reference)) {
                throw new DuplicateParameterReferenceException(reference);
            }
            if (!reference.equals(ParameterReference.UNREFERENCABLE)) {
                this.refToParamMap.put(reference, fcsParameter);
            }
            ++i;
        }
    }

    public FcsParameter getByParameterNumber(int paramNumber) {
        return this.parameterList.get(paramNumber - 1);
    }

    @Override
    public FcsParameter get(int index) {
        return this.parameterList.get(index);
    }

    @Override
    public int size() {
        return this.parameterList.size();
    }

    @Override
    public boolean containsByReference(ParameterReference ref) {
        return this.refToParamMap.containsKey(ref);
    }

    @Override
    public FcsParameter get(ParameterReference reference) {
        if (reference.equals(ParameterReference.UNREFERENCABLE)) {
            return null;
        }
        return this.refToParamMap.get(reference);
    }

    @Override
    public Set<ParameterReference> getParameterReferences() {
        return Collections.unmodifiableSet(this.refToParamMap.keySet());
    }
}

