/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.facejava.fcsdata.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;
import org.flowcyt.facejava.fcsdata.Event;
import org.flowcyt.facejava.fcsdata.exception.DuplicateParameterReferenceException;
import org.flowcyt.facejava.fcsdata.exception.InvalidCFCSDataSetTypeException;
import org.flowcyt.facejava.fcsdata.exception.InvalidDataSetsException;
import org.flowcyt.facejava.fcsdata.exception.InvalidParameterNumberException;
import org.flowcyt.facejava.fcsdata.impl.FcsDataFile;
import org.flowcyt.facejava.fcsdata.impl.FcsDataSet;
import org.flowcyt.facejava.fcsdata.impl.FcsParameter;

public class CFCSInput {
    public FcsDataFile read(InputStream is) throws IOException, InvalidDataSetsException {
        CFCSSystem readSystem = new CFCSSystem();
        try {
            readSystem.open(is);
        }
        catch (CFCSError e) {
            if (e.errorNumber == -14) {
                throw new IOException(e.toString());
            }
            throw e;
        }
        return this.extractData(readSystem);
    }

    private FcsDataFile extractData(CFCSSystem readSystem) throws InvalidDataSetsException {
        ArrayList<FcsDataSet> dataSets = new ArrayList<FcsDataSet>();
        HashMap<Integer, Exception> invalidDataSets = new HashMap<Integer, Exception>();
        for (int i = 0; i < readSystem.getCount(); ++i) {
            CFCSDataSet cfcsDs = readSystem.getDataSet(i);
            try {
                dataSets.add(this.extractDataSet(cfcsDs, i + 1));
                continue;
            }
            catch (InvalidCFCSDataSetTypeException ex) {
                invalidDataSets.put(i + 1, ex);
                continue;
            }
            catch (DuplicateParameterReferenceException ex) {
                invalidDataSets.put(i + 1, ex);
                continue;
            }
            catch (InvalidParameterNumberException ex) {
                invalidDataSets.put(i + 1, ex);
            }
        }
        if (invalidDataSets.size() > 0) {
            throw new InvalidDataSetsException(invalidDataSets);
        }
        return new FcsDataFile(dataSets);
    }

    private FcsDataSet extractDataSet(CFCSDataSet cfcsDs, int datasetNumber) throws InvalidCFCSDataSetTypeException, InvalidParameterNumberException, DuplicateParameterReferenceException {
        CFCSData readData = cfcsDs.getData();
        if (readData.getType() != 1) {
            throw new InvalidCFCSDataSetTypeException();
        }
        CFCSParameters cfcsDsParams = cfcsDs.getParameters();
        int parameterCount = cfcsDsParams.getCount();
        ArrayList<FcsParameter> parameters = new ArrayList<FcsParameter>(parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            FcsParameter param;
            CFCSParameter cfcsParam = cfcsDsParams.getParameter(i);
            try {
                param = new FcsParameter(cfcsParam.getShortName(), i + 1);
            }
            catch (CFCSError e) {
                param = new FcsParameter(i + 1);
            }
            parameters.add(param);
        }
        CFCSListModeData readLMData = (CFCSListModeData)readData;
        int eventCount = readLMData.getCount();
        ArrayList<Event> events = new ArrayList<Event>(eventCount);
        for (int i = 0; i < eventCount; ++i) {
            double[] doubleData = new double[parameterCount];
            readLMData.getEvent(i, doubleData);
            events.add(new Event(doubleData));
        }
        return new FcsDataSet(cfcsDs.getVersion(), datasetNumber, parameters, events);
    }
}

