/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.facejava.fcsdata.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;
import org.flowcyt.facejava.fcsdata.DataRetriever;
import org.flowcyt.facejava.fcsdata.Event;
import org.flowcyt.facejava.fcsdata.Parameter;
import org.flowcyt.facejava.fcsdata.ParameterReference;
import org.flowcyt.facejava.fcsdata.Population;
import org.flowcyt.facejava.fcsdata.exception.DataRetrievalException;
import org.flowcyt.facejava.fcsdata.io.FcsOutput;

public class CFCSOutput
implements FcsOutput {
    private static final double DEFAULT_LOG_DECADES = 0.0;
    private static final double DEFAULT_LOG_OFFSET = 0.0;
    private boolean writeDoubles;

    public CFCSOutput() {
        this.writeDoubles = false;
    }

    public CFCSOutput(boolean writeDoubles) {
        this.writeDoubles = writeDoubles;
    }

    public void setWriteDoubles(boolean writeDoubles) {
        this.writeDoubles = writeDoubles;
    }

    public boolean isWriteDoubles() {
        return this.writeDoubles;
    }

    @Override
    public void write(String uriString, Collection<? extends Population> popColl) throws DataRetrievalException, MalformedURLException, URISyntaxException {
        this.write(new URI(uriString), popColl);
    }

    @Override
    public void write(File file, Collection<? extends Population> popColl) throws DataRetrievalException, MalformedURLException {
        this.write(file.toURL(), popColl);
    }

    @Override
    public void write(URI uri, Collection<? extends Population> popColl) throws DataRetrievalException, MalformedURLException {
        try {
            this.write(uri.toURL(), popColl);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    public void write(URL url, Collection<? extends Population> popColl) throws DataRetrievalException {
        CFCSSystem system = new CFCSSystem();
        system.create(url.toString());
        for (Population population : popColl) {
            this.writePopulation(system, population);
        }
        system.close();
    }

    @Override
    public void write(String uriString, Population pop) throws DataRetrievalException, MalformedURLException, URISyntaxException {
        this.write(new URI(uriString), pop);
    }

    @Override
    public void write(File file, Population pop) throws DataRetrievalException, MalformedURLException {
        this.write(file.toURL(), pop);
    }

    @Override
    public void write(URI uri, Population pop) throws DataRetrievalException, MalformedURLException {
        try {
            this.write(uri.toURL(), pop);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    public void write(URL url, Population pop) throws DataRetrievalException {
        CFCSSystem system = new CFCSSystem();
        system.create(url.toString());
        this.writePopulation(system, pop);
        system.close();
    }

    private void writePopulation(CFCSSystem system, Population pop) throws DataRetrievalException {
        CFCSDataSet cfcsDs = this.writeDoubles ? system.createDataSet(1, 3) : system.createDataSet(1, 2);
        CFCSParameters cfcsParams = cfcsDs.getParameters();
        DataRetriever retriever = pop.getRetriever();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(retriever.getAllParameters());
        CFCSListModeData cfcsData = (CFCSListModeData)cfcsDs.getData();
        double[] range = new double[parameters.size()];
        Arrays.fill(range, Double.NEGATIVE_INFINITY);
        if (this.writeDoubles) {
            this.writeDoubleData(cfcsData, pop, parameters, retriever, range);
        } else {
            this.writeFloatData(cfcsData, pop, parameters, retriever, range);
        }
        int i = 0;
        for (Parameter param : parameters) {
            CFCSParameter cfcsParam = new CFCSParameter();
            if (this.writeDoubles) {
                cfcsParam.setFieldSize(64);
            } else {
                cfcsParam.setFieldSize(32);
            }
            if (!param.getReference().equals(ParameterReference.UNREFERENCABLE)) {
                cfcsParam.setShortName(param.getReference().getValue());
            }
            cfcsParam.setLogDecades(0.0);
            cfcsParam.setOffset(0.0);
            int pnr = (int)Math.min(2.147483647E9, Math.max(2.0, Math.ceil(range[i++])));
            cfcsParam.setRange(pnr);
            cfcsParams.addParameter(cfcsParam);
        }
    }

    private void writeDoubleData(CFCSListModeData cfcsData, Population pop, List<Parameter> parameters, DataRetriever retriever, double[] range) throws DataRetrievalException {
        double[] eventData = new double[parameters.size()];
        for (Event ev : pop) {
            int i = 0;
            for (Parameter param : parameters) {
                eventData[i] = retriever.getScale(param, ev);
                range[i] = Math.max(range[i], eventData[i]);
                ++i;
            }
            cfcsData.addEvent(eventData);
        }
    }

    private void writeFloatData(CFCSListModeData cfcsData, Population pop, List<Parameter> parameters, DataRetriever retriever, double[] range) throws DataRetrievalException {
        float[] eventData = new float[parameters.size()];
        for (Event ev : pop) {
            int i = 0;
            for (Parameter param : parameters) {
                eventData[i] = (float)retriever.getScale(param, ev);
                range[i] = Math.max(range[i], (double)eventData[i]);
                ++i;
            }
            cfcsData.addEvent(eventData);
        }
    }
}

