/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.co.flamingpenguin.jewel.cli.Argument;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollectionImpl;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.ParsedOptionSpecification;
import uk.co.flamingpenguin.jewel.cli.UnparsedOptionSpecification;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilder;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilderImpl;

class ArgumentValidatorImpl<O> {
    private final ValidationErrorBuilder m_validationErrorBuilder;
    private final List<String> m_validatedUnparsedArguments;
    private final Map<String, List<String>> m_validatedArguments;
    private final OptionsSpecification<O> m_specification;

    public ArgumentValidatorImpl(OptionsSpecification<O> specification) {
        this.m_specification = specification;
        this.m_validatedArguments = new LinkedHashMap<String, List<String>>();
        this.m_validatedUnparsedArguments = new ArrayList<String>();
        this.m_validationErrorBuilder = new ValidationErrorBuilderImpl();
    }

    public ArgumentCollection validateArguments(ArgumentCollection arguments) throws ArgumentValidationException {
        this.m_validatedUnparsedArguments.addAll(arguments.getUnparsed());
        Iterator argumentsIterator = arguments.iterator();
        while (argumentsIterator.hasNext()) {
            boolean isLast;
            Argument argument = (Argument)argumentsIterator.next();
            boolean bl = isLast = !argumentsIterator.hasNext();
            if (!this.m_specification.isSpecified(argument.getOptionName())) {
                this.m_validationErrorBuilder.unexpectedOption(argument.getOptionName());
                continue;
            }
            ParsedOptionSpecification optionSpecification = this.m_specification.getSpecification(argument.getOptionName());
            if (optionSpecification.isHelpOption()) {
                this.m_validationErrorBuilder.helpRequested(this.m_specification);
            } else if (argument.getValues().size() == 0 && optionSpecification.hasValue() && !optionSpecification.isMultiValued()) {
                this.m_validationErrorBuilder.missingValue(optionSpecification);
            } else if (!isLast && argument.getValues().size() > 0 && !optionSpecification.hasValue()) {
                this.m_validationErrorBuilder.unexpectedValue(optionSpecification);
            } else if (!isLast && argument.getValues().size() > 1 && !optionSpecification.isMultiValued()) {
                this.m_validationErrorBuilder.unexpectedAdditionalValues(optionSpecification);
            }
            if (isLast && this.hasExcessValues(argument, optionSpecification)) {
                List<String> unparsed;
                ArrayList<String> values = new ArrayList<String>();
                if (optionSpecification.hasValue()) {
                    values.add(argument.getValues().get(0));
                    unparsed = new ArrayList<String>(argument.getValues().subList(1, argument.getValues().size()));
                } else {
                    unparsed = argument.getValues();
                }
                this.m_validatedArguments.put(argument.getOptionName(), values);
                this.m_validatedUnparsedArguments.addAll(0, unparsed);
                continue;
            }
            this.checkAndAddValues(optionSpecification, argument.getOptionName(), new ArrayList<String>(argument.getValues()));
        }
        for (ParsedOptionSpecification optionSpecification : this.m_specification.getMandatoryOptions()) {
            if (arguments.containsAny(optionSpecification.getNames())) continue;
            this.m_validationErrorBuilder.missingOption(optionSpecification);
        }
        this.validateUnparsedOptions();
        this.m_validationErrorBuilder.validate();
        return new ArgumentCollectionImpl(this.m_validatedArguments, this.m_validatedUnparsedArguments);
    }

    private void validateUnparsedOptions() {
        if (this.m_specification.hasUnparsedSpecification()) {
            UnparsedOptionSpecification argumentSpecification = this.m_specification.getUnparsedSpecification();
            if (!argumentSpecification.isMultiValued() && !argumentSpecification.isOptional() && this.m_validatedUnparsedArguments.isEmpty()) {
                this.m_validationErrorBuilder.missingValue(argumentSpecification);
            } else if (!argumentSpecification.isMultiValued() && this.m_validatedArguments.size() > 1) {
                this.m_validationErrorBuilder.unexpectedValue(argumentSpecification);
            }
        }
    }

    private boolean hasExcessValues(Argument entry, ParsedOptionSpecification optionSpecification) {
        return !optionSpecification.isMultiValued() && (entry.getValues().size() > 1 || entry.getValues().size() > 0 && !optionSpecification.hasValue());
    }

    private void checkAndAddValues(ParsedOptionSpecification optionSpecification, String option, ArrayList<String> values) {
        for (String value : values) {
            if (this.patternMatches(optionSpecification, value)) continue;
            this.m_validationErrorBuilder.patternMismatch(optionSpecification, value);
        }
        this.m_validatedArguments.put(option, new ArrayList<String>(values));
    }

    private boolean patternMatches(ParsedOptionSpecification optionSpecification, String value) {
        return value.matches(optionSpecification.getPattern());
    }
}

