/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.marker;

import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerArea;
import com.jidesoft.marker.MarkerEvent;
import com.jidesoft.marker.MarkerListener;
import com.jidesoft.marker.MarkerModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMarkerModel
implements MarkerModel,
PropertyChangeListener {
    protected List<Marker> _markers;
    protected boolean _isAdjusting;
    protected EventListenerList _listenerList = new EventListenerList();

    public DefaultMarkerModel() {
        this._markers = new Vector<Marker>();
    }

    @Override
    public synchronized List<Marker> getMarkers() {
        Collections.sort(this._markers, new Comparator<Marker>(){

            @Override
            public int compare(Marker marker, Marker marker2) {
                int n2;
                block4: {
                    int n3;
                    block2: {
                        int n4;
                        int n5;
                        int n6;
                        block3: {
                            n6 = MarkerArea.d;
                            n5 = marker.getType();
                            n4 = marker2.getType();
                            n2 = n5;
                            n3 = n4;
                            if (n6 != 0) break block2;
                            if (n2 != n3) break block3;
                            n2 = 0;
                            break block4;
                        }
                        n2 = n5;
                        if (n6 != 0) break block4;
                        n3 = n4;
                    }
                    n2 = n2 > n3 ? -1 : 1;
                }
                return n2;
            }
        });
        return Collections.unmodifiableList(this._markers);
    }

    @Override
    public synchronized List<Marker> getMarkersAt(int n2, int n3) {
        int n4 = MarkerArea.d;
        Vector<Marker> vector = new Vector<Marker>();
        for (Marker marker : this._markers) {
            block6: {
                int n5;
                int n6;
                block5: {
                    n6 = marker.getStartOffset();
                    n5 = n3;
                    if (n4 != 0) break block5;
                    if (n6 > n5) break block6;
                    n6 = marker.getEndOffset();
                    if (n4 != 0) break block6;
                    n5 = n2;
                }
                if (n6 >= n5) {
                    n6 = vector.add(marker) ? 1 : 0;
                }
            }
            if (n4 == 0) continue;
        }
        return vector;
    }

    @Override
    public synchronized boolean isAdjusting() {
        return this._isAdjusting;
    }

    @Override
    public synchronized void setAdjusting(boolean bl) {
        block3: {
            DefaultMarkerModel defaultMarkerModel;
            block2: {
                this._isAdjusting = bl;
                defaultMarkerModel = this;
                if (MarkerArea.d != 0) break block2;
                if (defaultMarkerModel.isAdjusting()) break block3;
                defaultMarkerModel = this;
            }
            defaultMarkerModel.fireMarkerChanged(null, 2, this.isAdjusting());
        }
    }

    @Override
    public synchronized Marker addMarker(int n2, int n3, int n4, String string) {
        block3: {
            Marker marker;
            block2: {
                marker = this.createMarker(n2, n3, n4, string);
                marker.addPropertyChangeListener(this);
                boolean bl = this._markers.add(marker);
                if (MarkerArea.d != 0) break block2;
                if (!bl) break block3;
                this.fireMarkerChanged(marker, 0, this.isAdjusting());
            }
            return marker;
        }
        return null;
    }

    protected Marker createMarker(int n2, int n3, int n4, String string) {
        return new Marker(n2, n3, n4, string);
    }

    @Override
    public synchronized void clearMarkers() {
        block8: {
            List<Marker> list;
            block9: {
                int n2 = MarkerArea.d;
                List<Marker> list2 = this._markers;
                if (n2 == 0) {
                    if (list2 == null) {
                        return;
                    }
                    list2 = this._markers;
                }
                for (Marker marker : list2) {
                    marker.removePropertyChangeListener(this);
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block8;
                }
                list = this._markers;
                if (n2 != 0) break block9;
                if (list.size() <= 0) break block8;
                list = this._markers;
            }
            list.clear();
            this.fireMarkerChanged(null, 1, this.isAdjusting());
        }
    }

    @Override
    public synchronized boolean removeMarker(Marker marker) {
        boolean bl;
        block2: {
            boolean bl2;
            block3: {
                block5: {
                    Marker marker2;
                    block4: {
                        int n2 = MarkerArea.d;
                        bl = bl2 = this._markers.remove(marker);
                        if (n2 != 0) break block2;
                        if (!bl) break block3;
                        marker2 = marker;
                        if (n2 != 0) break block4;
                        if (marker2 == null) break block5;
                        marker2 = marker;
                    }
                    marker2.removePropertyChangeListener(this);
                }
                this.fireMarkerChanged(marker, 1, this.isAdjusting());
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public synchronized void updateMarker(Marker marker) {
        this.fireMarkerChanged(marker, 2, this.isAdjusting());
    }

    protected void fireMarkerChanged(Marker marker, int n2, boolean bl) {
        int n3 = MarkerArea.d;
        Object[] objectArray = this._listenerList.getListenerList();
        Object object = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != MarkerListener.class) continue;
            Object object2 = object;
            if (n3 == 0) {
                if (object2 == null) {
                    object = new MarkerEvent(this, marker, n2, bl);
                }
                object2 = objectArray[i2 + 1];
            }
            ((MarkerListener)object2).markerChanged((MarkerEvent)object);
            if (n3 == 0) continue;
        }
    }

    @Override
    public void addMarkerListener(MarkerListener markerListener) {
        this._listenerList.add(MarkerListener.class, markerListener);
    }

    @Override
    public void removeMarkerListener(MarkerListener markerListener) {
        this._listenerList.remove(MarkerListener.class, markerListener);
    }

    @Override
    public MarkerListener[] getMarkerListeners() {
        return (MarkerListener[])this._listenerList.getListeners(MarkerListener.class);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Marker) {
            this.updateMarker((Marker)propertyChangeEvent.getSource());
        }
    }
}

