/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.lang.reflect.Array;
import ncsa.hdf.hdflib.ArrayDescriptor;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;
import ncsa.hdf.hdflib.HDFNativeData;

public class HDFArray {
    private Object _theArray = null;
    private ArrayDescriptor _desc = null;
    private byte[] _barray = null;

    public HDFArray(Object anArray) throws HDFException {
        Class<?> tc;
        if (anArray == null) {
            HDFJavaException ex = new HDFJavaException("HDFArray: array is null?: ");
            ex.printStackTrace();
        }
        if (!(tc = anArray.getClass()).isArray()) {
            HDFJavaException ex = new HDFJavaException("HDFArray: not an array?: ");
            ex.printStackTrace();
            throw ex;
        }
        this._theArray = anArray;
        this._desc = new ArrayDescriptor(this._theArray);
        if (this._desc == null) {
            HDFJavaException ex = new HDFJavaException("HDFArray: internal error: array description failed?: ");
            throw ex;
        }
    }

    public byte[] emptyBytes() throws HDFException {
        byte[] b = null;
        b = ArrayDescriptor.dims == 1 && ArrayDescriptor.NT == 'B' ? (byte[])this._theArray : new byte[ArrayDescriptor.totalSize];
        if (b == null) {
            System.out.println("Error:  HDFArray can't allocate bytes for array");
            HDFJavaException ex = new HDFJavaException("HDFArray: emptyBytes: allocation failed");
            throw ex;
        }
        return b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] byteify() throws HDFException {
        int i;
        if (this._barray != null) {
            return this._barray;
        }
        if (this._theArray == null) {
            HDFJavaException ex = new HDFJavaException("HDFArray: byteify not an array?: ");
            throw ex;
        }
        if (ArrayDescriptor.dims == 1) {
            if (ArrayDescriptor.NT == 'B') {
                this._barray = (byte[])this._theArray;
                return this._barray;
            }
            try {
                byte[] therow;
                this._barray = new byte[ArrayDescriptor.totalSize];
                if (ArrayDescriptor.NT == 'I') {
                    therow = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[1], (int[])this._theArray);
                } else if (ArrayDescriptor.NT == 'S') {
                    therow = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[1], (short[])this._theArray);
                } else if (ArrayDescriptor.NT == 'F') {
                    therow = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[1], (float[])this._theArray);
                } else if (ArrayDescriptor.NT == 'J') {
                    therow = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[1], (long[])this._theArray);
                } else if (ArrayDescriptor.NT == 'D') {
                    therow = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[1], (double[])this._theArray);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDFJavaException ex = new HDFJavaException("HDFArray: unknown type of Object?");
                        throw ex;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        therow = this.ByteObjToByte((Byte[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        therow = this.IntegerToByte((Integer[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        therow = this.ShortToByte((Short[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        therow = this.FloatObjToByte((Float[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        therow = this.DoubleObjToByte((Double[])this._theArray);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDFJavaException ex = new HDFJavaException("HDFArray: unknown type of Object?");
                            throw ex;
                        }
                        therow = this.LongObjToByte((Long[])this._theArray);
                    }
                }
                System.arraycopy(therow, 0, this._barray, 0, ArrayDescriptor.dimlen[1] * ArrayDescriptor.NTsize);
                return this._barray;
            }
            catch (OutOfMemoryError err) {
                HDFJavaException ex = new HDFJavaException("HDFArray: byteify array too big?");
                ex.printStackTrace();
                throw ex;
            }
        }
        try {
            this._barray = new byte[ArrayDescriptor.totalSize];
        }
        catch (OutOfMemoryError err) {
            HDFJavaException ex = new HDFJavaException("HDFArray: byteify array too big?");
            ex.printStackTrace();
            throw ex;
        }
        Object oo = this._theArray;
        int n = 0;
        int index = 0;
        while (true) {
            if (n >= ArrayDescriptor.totalSize) {
                if (n < ArrayDescriptor.totalSize) {
                    throw new InternalError(new String("HDFArray:::byteify: Panic didn't complete all input data: n=  " + n + " size = " + ArrayDescriptor.totalSize));
                }
                break;
            }
            oo = ArrayDescriptor.objs[0];
            index = n / ArrayDescriptor.bytetoindex[0];
            index %= ArrayDescriptor.dimlen[0];
            for (i = 0; i < ArrayDescriptor.dims; ++i) {
                index = n / ArrayDescriptor.bytetoindex[i];
                if ((index %= ArrayDescriptor.dimlen[i]) == ArrayDescriptor.currentindex[i]) {
                    oo = ArrayDescriptor.objs[i];
                    continue;
                }
                if (index > ArrayDescriptor.dimlen[i] - 1) {
                    System.out.println("out of bounds?");
                    return null;
                }
                oo = Array.get(oo, index);
                ArrayDescriptor.currentindex[i] = index;
                ArrayDescriptor.objs[i] = oo;
            }
            try {
                byte[] arow;
                if (ArrayDescriptor.NT == 'J') {
                    arow = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    arow = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'I') {
                    arow = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (int[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'S') {
                    arow = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'B') {
                    arow = (byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1];
                } else if (ArrayDescriptor.NT == 'F') {
                    arow = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'D') {
                    arow = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDFJavaException ex = new HDFJavaException("HDFArray: byteify Object type not implemented?");
                        throw ex;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        arow = this.ByteObjToByte((Byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        arow = this.IntegerToByte((Integer[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        arow = this.ShortToByte((Short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        arow = this.FloatObjToByte((Float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        arow = this.DoubleObjToByte((Double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDFJavaException ex = new HDFJavaException("HDFArray: byteify Object type not implemented?");
                            throw ex;
                        }
                        arow = this.LongObjToByte((Long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    }
                }
                System.arraycopy(arow, 0, this._barray, n, ArrayDescriptor.dimlen[ArrayDescriptor.dims] * ArrayDescriptor.NTsize);
                n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
            }
            catch (OutOfMemoryError err) {
                HDFJavaException ex = new HDFJavaException("HDFArray: byteify array too big?");
                ex.printStackTrace();
                throw ex;
            }
        }
        i = 0;
        while (i < ArrayDescriptor.dims) {
            if (ArrayDescriptor.currentindex[i] != ArrayDescriptor.dimlen[i] - 1) {
                throw new InternalError(new String("Panic didn't complete all data: currentindex[" + i + "] = " + ArrayDescriptor.currentindex[i] + " (should be " + (ArrayDescriptor.dimlen[i] - 1) + " ?)"));
            }
            ++i;
        }
        return this._barray;
    }

    public Object arrayify(byte[] bytes) throws HDFException {
        int i;
        HDFJavaException ex;
        if (this._theArray == null) {
            HDFJavaException ex2 = new HDFJavaException("arrayify: not an array?: ");
            throw ex2;
        }
        if (Array.getLength(bytes) != ArrayDescriptor.totalSize) {
            ex = new HDFJavaException("arrayify: array is wrong size?: ");
        }
        this._barray = bytes;
        if (ArrayDescriptor.dims == 1) {
            try {
                Object[] x;
                if (ArrayDescriptor.NT == 'I') {
                    x = HDFNativeData.byteToInt(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'S') {
                    x = HDFNativeData.byteToShort(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'F') {
                    x = HDFNativeData.byteToFloat(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'J') {
                    x = HDFNativeData.byteToLong(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'D') {
                    x = HDFNativeData.byteToDouble(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'L') {
                    Number[] I;
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        I = this.ByteToByteObj(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        I = this.ByteToInteger(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        I = this.ByteToShort(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        I = this.ByteToFloatObj(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        I = this.ByteToDoubleObj(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        I = this.ByteToLongObj(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    ex = new HDFJavaException("arrayify:  Object type not implemented yet...");
                    throw ex;
                }
                ex = new HDFJavaException("arrayify:  Object type not implemented yet...");
                throw ex;
            }
            catch (OutOfMemoryError err) {
                HDFJavaException ex3 = new HDFJavaException("HDFArray: arrayify array too big?");
                ex3.printStackTrace();
                throw ex3;
            }
        }
        Object oo = this._theArray;
        int n = 0;
        int index = 0;
        while (n < ArrayDescriptor.totalSize) {
            oo = ArrayDescriptor.objs[0];
            index = n / ArrayDescriptor.bytetoindex[0];
            index %= ArrayDescriptor.dimlen[0];
            for (i = 0; i < ArrayDescriptor.dims; ++i) {
                index = n / ArrayDescriptor.bytetoindex[i];
                if ((index %= ArrayDescriptor.dimlen[i]) == ArrayDescriptor.currentindex[i]) {
                    oo = ArrayDescriptor.objs[i];
                    continue;
                }
                if (index > ArrayDescriptor.dimlen[i] - 1) {
                    System.out.println("out of bounds?");
                    return null;
                }
                oo = Array.get(oo, index);
                ArrayDescriptor.currentindex[i] = index;
                ArrayDescriptor.objs[i] = oo;
            }
            try {
                HDFJavaException ex4;
                Object[] arow;
                if (ArrayDescriptor.NT == 'J') {
                    arow = HDFNativeData.byteToLong(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], arow);
                    n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n2 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n2] = ArrayDescriptor.currentindex[n2] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'I') {
                    arow = HDFNativeData.byteToInt(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], arow);
                    n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n3 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n3] = ArrayDescriptor.currentindex[n3] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'S') {
                    arow = HDFNativeData.byteToShort(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], arow);
                    n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n4 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n4] = ArrayDescriptor.currentindex[n4] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, n, ArrayDescriptor.objs[ArrayDescriptor.dims - 1], 0, ArrayDescriptor.dimlen[ArrayDescriptor.dims]);
                    n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    continue;
                }
                if (ArrayDescriptor.NT == 'F') {
                    arow = HDFNativeData.byteToFloat(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], arow);
                    n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n5 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n5] = ArrayDescriptor.currentindex[n5] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'D') {
                    arow = HDFNativeData.byteToDouble(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], arow);
                    n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n6 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n6] = ArrayDescriptor.currentindex[n6] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'L') {
                    Number[] I;
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        I = this.ByteToByteObj(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], I);
                        n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n7 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n7] = ArrayDescriptor.currentindex[n7] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        I = this.ByteToInteger(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], I);
                        n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n8 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n8] = ArrayDescriptor.currentindex[n8] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        I = this.ByteToShort(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], I);
                        n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n9 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n9] = ArrayDescriptor.currentindex[n9] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        I = this.ByteToFloatObj(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], I);
                        n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n10 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n10] = ArrayDescriptor.currentindex[n10] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        I = this.ByteToDoubleObj(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], I);
                        n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n11 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n11] = ArrayDescriptor.currentindex[n11] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        I = this.ByteToLongObj(n, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], I);
                        n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n12 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n12] = ArrayDescriptor.currentindex[n12] + 1;
                        continue;
                    }
                    ex4 = new HDFJavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                    throw ex4;
                }
                ex4 = new HDFJavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                throw ex4;
            }
            catch (OutOfMemoryError err) {
                HDFJavaException ex5 = new HDFJavaException("HDFArray: arrayify array too big?");
                ex5.printStackTrace();
                throw ex5;
            }
        }
        if (n < ArrayDescriptor.totalSize) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all input data: n=  " + n + " size = " + ArrayDescriptor.totalSize));
        }
        for (i = 0; i <= ArrayDescriptor.dims - 2; ++i) {
            if (ArrayDescriptor.currentindex[i] == ArrayDescriptor.dimlen[i] - 1) continue;
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + i + "] = " + ArrayDescriptor.currentindex[i] + " (should be " + (ArrayDescriptor.dimlen[i] - 1) + "?"));
        }
        if (ArrayDescriptor.NT != 'B') {
            if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1]) {
                throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + i + "] = " + ArrayDescriptor.currentindex[i] + " (should be " + ArrayDescriptor.dimlen[i] + "?"));
            }
        } else if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1] - 1) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + i + "] = " + ArrayDescriptor.currentindex[i] + " (should be " + (ArrayDescriptor.dimlen[i] - 1) + "?"));
        }
        return this._theArray;
    }

    private byte[] IntegerToByte(Integer[] in) {
        int nelems = Array.getLength(in);
        int[] out = new int[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return HDFNativeData.intToByte(0, nelems, out);
    }

    private Integer[] ByteToInteger(byte[] bin) {
        int[] in = HDFNativeData.byteToInt(bin);
        int nelems = Array.getLength(in);
        Integer[] out = new Integer[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Integer(in[i]);
        }
        return out;
    }

    private Integer[] ByteToInteger(int start, int len, byte[] bin) {
        int[] in = HDFNativeData.byteToInt(start, len, bin);
        int nelems = Array.getLength(in);
        Integer[] out = new Integer[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Integer(in[i]);
        }
        return out;
    }

    private byte[] ShortToByte(Short[] in) {
        int nelems = Array.getLength(in);
        short[] out = new short[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return HDFNativeData.shortToByte(0, nelems, out);
    }

    private Short[] ByteToShort(byte[] bin) {
        short[] in = HDFNativeData.byteToShort(bin);
        int nelems = Array.getLength(in);
        Short[] out = new Short[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Short(in[i]);
        }
        return out;
    }

    private Short[] ByteToShort(int start, int len, byte[] bin) {
        short[] in = HDFNativeData.byteToShort(start, len, bin);
        int nelems = Array.getLength(in);
        Short[] out = new Short[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Short(in[i]);
        }
        return out;
    }

    private byte[] ByteObjToByte(Byte[] in) {
        int nelems = Array.getLength(in);
        byte[] out = new byte[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private Byte[] ByteToByteObj(byte[] bin) {
        int nelems = Array.getLength(bin);
        Byte[] out = new Byte[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Byte(bin[i]);
        }
        return out;
    }

    private Byte[] ByteToByteObj(int start, int len, byte[] bin) {
        Byte[] out = new Byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = new Byte(bin[i]);
        }
        return out;
    }

    private byte[] FloatObjToByte(Float[] in) {
        int nelems = Array.getLength(in);
        float[] out = new float[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i].floatValue();
        }
        return HDFNativeData.floatToByte(0, nelems, out);
    }

    private Float[] ByteToFloatObj(byte[] bin) {
        float[] in = HDFNativeData.byteToFloat(bin);
        int nelems = Array.getLength(in);
        Float[] out = new Float[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Float(in[i]);
        }
        return out;
    }

    private Float[] ByteToFloatObj(int start, int len, byte[] bin) {
        float[] in = HDFNativeData.byteToFloat(start, len, bin);
        int nelems = Array.getLength(in);
        Float[] out = new Float[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Float(in[i]);
        }
        return out;
    }

    private byte[] DoubleObjToByte(Double[] in) {
        int nelems = Array.getLength(in);
        double[] out = new double[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return HDFNativeData.doubleToByte(0, nelems, out);
    }

    private Double[] ByteToDoubleObj(byte[] bin) {
        double[] in = HDFNativeData.byteToDouble(bin);
        int nelems = Array.getLength(in);
        Double[] out = new Double[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Double(in[i]);
        }
        return out;
    }

    private Double[] ByteToDoubleObj(int start, int len, byte[] bin) {
        double[] in = HDFNativeData.byteToDouble(start, len, bin);
        int nelems = Array.getLength(in);
        Double[] out = new Double[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Double(in[i]);
        }
        return out;
    }

    private byte[] LongObjToByte(Long[] in) {
        int nelems = Array.getLength(in);
        long[] out = new long[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return HDFNativeData.longToByte(0, nelems, out);
    }

    private Long[] ByteToLongObj(byte[] bin) {
        long[] in = HDFNativeData.byteToLong(bin);
        int nelems = Array.getLength(in);
        Long[] out = new Long[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Long(in[i]);
        }
        return out;
    }

    private Long[] ByteToLongObj(int start, int len, byte[] bin) {
        long[] in = HDFNativeData.byteToLong(start, len, bin);
        int nelems = Array.getLength(in);
        Long[] out = new Long[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = new Long(in[i]);
        }
        return out;
    }
}

