/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import javax.media.jai.WarpGrid;
import javax.media.jai.WarpOpImage;
import mediaLib.mediaLibImage;
import mediaLibwrapper.Image;

final class MlibWarpGridOpImage
extends WarpOpImage {
    private int xStart;
    private int xStep;
    private int xNumCells;
    private int xEnd;
    private int yStart;
    private int yStep;
    private int yNumCells;
    private int yEnd;
    private float[] xWarpPos;
    private float[] yWarpPos;
    private int filter;

    public MlibWarpGridOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, WarpGrid warpGrid, Interpolation interpolation, int n) {
        super(renderedImage, borderExtender, tileCache, imageLayout, warpGrid, interpolation, true);
        this.filter = n;
        this.xStart = warpGrid.getXStart();
        this.xStep = warpGrid.getXStep();
        this.xNumCells = warpGrid.getXNumCells();
        this.xEnd = this.xStart + this.xStep * this.xNumCells;
        this.yStart = warpGrid.getYStart();
        this.yStep = warpGrid.getYStep();
        this.yNumCells = warpGrid.getYNumCells();
        this.yEnd = this.yStart + this.yStep * this.yNumCells;
        this.xWarpPos = warpGrid.getXWarpPos();
        this.yWarpPos = warpGrid.getYWarpPos();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        Raster raster = rasterArray[0];
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, raster.getBounds(), n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 2: 
            case 3: {
                int n2 = 0;
                while (n2 < mediaLibImageArray2.length) {
                    Image.GridWarp((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (float[])this.xWarpPos, (float[])this.yWarpPos, (double)raster.getMinX(), (double)raster.getMinY(), (int)(this.xStart - rectangle.x), (int)this.xStep, (int)this.xNumCells, (int)(this.yStart - rectangle.y), (int)this.yStep, (int)this.yNumCells, (int)this.filter, (int)0);
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    Image.GridWarp_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (float[])this.xWarpPos, (float[])this.yWarpPos, (double)raster.getMinX(), (double)raster.getMinY(), (int)(this.xStart - rectangle.x), (int)this.xStep, (int)this.xNumCells, (int)(this.yStart - rectangle.y), (int)this.yStep, (int)this.yNumCells, (int)this.filter, (int)0);
                    ++n3;
                }
                break;
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }

    public Raster computeTile(int n, int n2) {
        Rectangle rectangle;
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle2 = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight).intersection(this.writableBounds);
        if (rectangle2.isEmpty()) {
            return writableRaster;
        }
        Raster[] rasterArray = new Raster[1];
        Rectangle rectangle3 = this.source0.getBounds();
        int n3 = rectangle2.x;
        int n4 = n3 + rectangle2.width - 1;
        int n5 = rectangle2.y;
        int n6 = n5 + rectangle2.height - 1;
        if (n3 >= this.xEnd || n4 < this.xStart || n5 >= this.yEnd || n6 < this.yStart) {
            Rectangle rectangle4 = rectangle3.intersection(rectangle2);
            if (!rectangle4.isEmpty()) {
                rasterArray[0] = this.source0.getData(rectangle4);
                this.copyRect(rasterArray, writableRaster, rectangle4);
            }
            return writableRaster;
        }
        if (n3 < this.xStart) {
            rectangle = rectangle3.intersection(new Rectangle(n3, n5, this.xStart - n3, n6 - n5 + 1));
            if (!rectangle.isEmpty()) {
                rasterArray[0] = this.source0.getData(rectangle);
                this.copyRect(rasterArray, writableRaster, rectangle);
            }
            n3 = this.xStart;
        }
        if (n4 >= this.xEnd) {
            rectangle = rectangle3.intersection(new Rectangle(this.xEnd, n5, n4 - this.xEnd + 1, n6 - n5 + 1));
            if (!rectangle.isEmpty()) {
                rasterArray[0] = this.source0.getData(rectangle);
                this.copyRect(rasterArray, writableRaster, rectangle);
            }
            n4 = this.xEnd - 1;
        }
        if (n5 < this.yStart) {
            rectangle = rectangle3.intersection(new Rectangle(n3, n5, n4 - n3 + 1, this.yStart - n5));
            if (!rectangle.isEmpty()) {
                rasterArray[0] = this.source0.getData(rectangle);
                this.copyRect(rasterArray, writableRaster, rectangle);
            }
            n5 = this.yStart;
        }
        if (n6 >= this.yEnd) {
            rectangle = rectangle3.intersection(new Rectangle(n3, this.yEnd, n4 - n3 + 1, n6 - this.yEnd + 1));
            if (!rectangle.isEmpty()) {
                rasterArray[0] = this.source0.getData(rectangle);
                this.copyRect(rasterArray, writableRaster, rectangle);
            }
            n6 = this.yEnd - 1;
        }
        if (!(rectangle = this.warp.mapDestRect(rectangle2 = new Rectangle(n3, n5, n4 - n3 + 1, n6 - n5 + 1)).intersection(rectangle3)).isEmpty()) {
            int n7 = this.getLeftPadding();
            int n8 = this.getRightPadding();
            int n9 = this.getTopPadding();
            int n10 = this.getBottomPadding();
            rectangle = new Rectangle(rectangle.x - n7, rectangle.y - n9, rectangle.width + n7 + n8, rectangle.height + n9 + n10);
            rasterArray[0] = this.hasExtender(0) ? this.source0.getExtendedData(rectangle, this.extenders[0]) : this.source0.getData(rectangle);
            this.computeRect(rasterArray, writableRaster, rectangle2);
        }
        return writableRaster;
    }

    private void copyRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n2 = 0;
        while (n2 < mediaLibImageArray2.length) {
            Image.Copy((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2]);
            ++n2;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

