/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class CompositeOpImage
extends PointOpImage {
    protected PlanarImage source1Alpha;
    protected PlanarImage source2Alpha;
    protected boolean alphaPremultiplied;
    private int aOffset;
    private int cOffset;
    private byte maxValueByte;
    private short maxValueShort;
    private int maxValue;
    private float invMaxValue;

    public CompositeOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, TileCache tileCache, ImageLayout imageLayout, PlanarImage planarImage, PlanarImage planarImage2, boolean bl, boolean bl2) {
        super(renderedImage, renderedImage2, tileCache, imageLayout, true);
        this.source1Alpha = planarImage;
        this.source2Alpha = planarImage2;
        this.alphaPremultiplied = bl;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        int n2 = sampleModel.getNumBands() + 1;
        if (this.sampleModel.getTransferType() != n || this.sampleModel.getNumBands() != n2) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, n, this.tileWidth, this.tileHeight, n2);
            this.colorModel = PlanarImage.createColorModel(this.sampleModel);
        }
        this.aOffset = bl2 ? 0 : n2 - 1;
        this.cOffset = bl2 ? 1 : 0;
        switch (n) {
            case 0: {
                this.maxValue = 255;
                this.maxValueByte = (byte)-1;
                break;
            }
            case 1: {
                this.maxValue = 65535;
                this.maxValueShort = (short)-1;
                break;
            }
            case 2: {
                this.maxValue = Short.MAX_VALUE;
                this.maxValueShort = Short.MAX_VALUE;
                break;
            }
            case 3: {
                this.maxValue = Integer.MAX_VALUE;
                break;
            }
        }
        this.invMaxValue = 1.0f / (float)this.maxValue;
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[] byArray3 = rasterAccessor3.getByteDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        byte[] byArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            byArray4 = rasterAccessor4.getByteDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        byte[][] byArray5 = rasterAccessor5.getByteDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f = 1.0f - (float)(byArray3[n24 + n10] & 0xFF) * this.invMaxValue;
                        byArray5[this.aOffset][n25 + nArray3[this.aOffset]] = this.maxValueByte;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            byArray5[n28][n25 + nArray3[n28]] = (byte)((float)(byArray[n27][n22 + nArray[n27]] & 0xFF) + (float)(byArray2[n27][n23 + nArray2[n27]] & 0xFF) * f);
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        int n36 = byArray3[n32 + n10] & 0xFF;
                        float f = 1.0f - (float)n36 * this.invMaxValue;
                        byArray5[this.aOffset][n34 + nArray3[this.aOffset]] = (byte)((float)n36 + (float)(byArray4[n33 + n13] & 0xFF) * f);
                        int n37 = 0;
                        while (n37 < n3) {
                            int n38 = n37 + this.cOffset;
                            byArray5[n38][n34 + nArray3[n38]] = (byte)((float)(byArray[n37][n30 + nArray[n37]] & 0xFF) + (float)(byArray2[n37][n31 + nArray2[n37]] & 0xFF) * f);
                            ++n37;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n2) {
                int n40 = n16;
                int n41 = n17;
                int n42 = n18;
                int n43 = n20;
                int n44 = 0;
                while (n44 < n) {
                    float f = (float)(byArray3[n42 + n10] & 0xFF) * this.invMaxValue;
                    float f2 = 1.0f - f;
                    byArray5[this.aOffset][n43 + nArray3[this.aOffset]] = this.maxValueByte;
                    int n45 = 0;
                    while (n45 < n3) {
                        int n46 = n45 + this.cOffset;
                        byArray5[n46][n43 + nArray3[n46]] = (byte)((float)(byArray[n45][n40 + nArray[n45]] & 0xFF) * f + (float)(byArray2[n45][n41 + nArray2[n45]] & 0xFF) * f2);
                        ++n45;
                    }
                    n40 += n5;
                    n41 += n7;
                    n42 += n9;
                    n43 += n15;
                    ++n44;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n2) {
                int n48 = n16;
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = 0;
                while (n53 < n) {
                    float f;
                    float f3;
                    int n54 = byArray3[n50 + n10] & 0xFF;
                    float f4 = (1.0f - (float)n54 * this.invMaxValue) * (float)(byArray4[n51 + n13] & 0xFF);
                    float f5 = (float)n54 + f4;
                    if (f5 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = (float)n54 / f5;
                        f = f4 / f5;
                    }
                    byArray5[this.aOffset][n52 + nArray3[this.aOffset]] = (byte)f5;
                    int n55 = 0;
                    while (n55 < n3) {
                        int n56 = n55 + this.cOffset;
                        byArray5[n56][n52 + nArray3[n56]] = (byte)((float)(byArray[n55][n48 + nArray[n55]] & 0xFF) * f3 + (float)(byArray2[n55][n49 + nArray2[n55]] & 0xFF) * f);
                        ++n55;
                    }
                    n48 += n5;
                    n49 += n7;
                    n50 += n9;
                    n51 += n12;
                    n52 += n15;
                    ++n53;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n47;
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RenderedImage[] renderedImageArray = this.source2Alpha == null ? new RenderedImage[3] : new RenderedImage[4];
        renderedImageArray[0] = this.getSource(0);
        renderedImageArray[1] = this.getSource(1);
        renderedImageArray[2] = this.source1Alpha;
        Raster raster = this.source1Alpha.getData(rectangle);
        Raster raster2 = null;
        if (this.source2Alpha != null) {
            renderedImageArray[3] = this.source2Alpha;
            raster2 = this.source2Alpha.getData(rectangle);
        }
        RasterFormatTag[] rasterFormatTagArray = RasterAccessor.findCompatibleTags(renderedImageArray, this);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSource(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(raster, rectangle, rasterFormatTagArray[2], this.source1Alpha.getColorModel());
        RasterAccessor rasterAccessor4 = null;
        RasterAccessor rasterAccessor5 = null;
        if (this.source2Alpha != null) {
            rasterAccessor4 = new RasterAccessor(raster2, rectangle, rasterFormatTagArray[3], this.source2Alpha.getColorModel());
            rasterAccessor5 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[4], this.getColorModel());
        } else {
            rasterAccessor4 = null;
            rasterAccessor5 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[3], this.getColorModel());
        }
        switch (rasterAccessor5.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
        }
        rasterAccessor5.copyDataToRaster();
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[] dArray3 = rasterAccessor3.getDoubleDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        double[] dArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            dArray4 = rasterAccessor4.getDoubleDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        double[][] dArray5 = rasterAccessor5.getDoubleDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        double d = 5.562684646268003E-309;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        double d2 = 1.0 - dArray3[n24 + n10] * d;
                        dArray5[this.aOffset][n25 + nArray3[this.aOffset]] = Double.MAX_VALUE;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            dArray5[n28][n25 + nArray3[n28]] = dArray[n27][n22 + nArray[n27]] + dArray2[n27][n23 + nArray2[n27]] * d2;
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        double d3 = dArray3[n32 + n10];
                        double d4 = 1.0 - d3 * d;
                        dArray5[this.aOffset][n34 + nArray3[this.aOffset]] = d3 + dArray4[n33 + n13] * d4;
                        int n36 = 0;
                        while (n36 < n3) {
                            int n37 = n36 + this.cOffset;
                            dArray5[n37][n34 + nArray3[n37]] = dArray[n36][n30 + nArray[n36]] + dArray2[n36][n31 + nArray2[n36]] * d4;
                            ++n36;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n38 = 0;
            while (n38 < n2) {
                int n39 = n16;
                int n40 = n17;
                int n41 = n18;
                int n42 = n20;
                int n43 = 0;
                while (n43 < n) {
                    double d5 = dArray3[n41 + n10] * d;
                    double d6 = 1.0 - d5;
                    dArray5[this.aOffset][n42 + nArray3[this.aOffset]] = Double.MAX_VALUE;
                    int n44 = 0;
                    while (n44 < n3) {
                        int n45 = n44 + this.cOffset;
                        dArray5[n45][n42 + nArray3[n45]] = dArray[n44][n39 + nArray[n44]] * d5 + dArray2[n44][n40 + nArray2[n44]] * d6;
                        ++n44;
                    }
                    n39 += n5;
                    n40 += n7;
                    n41 += n9;
                    n42 += n15;
                    ++n43;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n38;
            }
        } else {
            int n46 = 0;
            while (n46 < n2) {
                int n47 = n16;
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = 0;
                while (n52 < n) {
                    double d7;
                    double d8;
                    double d9 = dArray3[n49 + n10];
                    double d10 = (1.0 - d9 * d) * dArray4[n50 + n13];
                    double d11 = d9 + d10;
                    if (d11 == 0.0) {
                        d8 = 0.0;
                        d7 = 0.0;
                    } else {
                        d8 = d9 / d11;
                        d7 = d10 / d11;
                    }
                    dArray5[this.aOffset][n51 + nArray3[this.aOffset]] = d11;
                    int n53 = 0;
                    while (n53 < n3) {
                        int n54 = n53 + this.cOffset;
                        dArray5[n54][n51 + nArray3[n54]] = dArray[n53][n47 + nArray[n53]] * d8 + dArray2[n53][n48 + nArray2[n53]] * d7;
                        ++n53;
                    }
                    n47 += n5;
                    n48 += n7;
                    n49 += n9;
                    n50 += n12;
                    n51 += n15;
                    ++n52;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n46;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[] fArray3 = rasterAccessor3.getFloatDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        float[] fArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            fArray4 = rasterAccessor4.getFloatDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        float[][] fArray5 = rasterAccessor5.getFloatDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        float f = 2.938736E-39f;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f2 = 1.0f - fArray3[n24 + n10] * f;
                        fArray5[this.aOffset][n25 + nArray3[this.aOffset]] = Float.MAX_VALUE;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            fArray5[n28][n25 + nArray3[n28]] = fArray[n27][n22 + nArray[n27]] + fArray2[n27][n23 + nArray2[n27]] * f2;
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        float f3 = fArray3[n32 + n10];
                        float f4 = 1.0f - f3 * f;
                        fArray5[this.aOffset][n34 + nArray3[this.aOffset]] = f3 + fArray4[n33 + n13] * f4;
                        int n36 = 0;
                        while (n36 < n3) {
                            int n37 = n36 + this.cOffset;
                            fArray5[n37][n34 + nArray3[n37]] = fArray[n36][n30 + nArray[n36]] + fArray2[n36][n31 + nArray2[n36]] * f4;
                            ++n36;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n38 = 0;
            while (n38 < n2) {
                int n39 = n16;
                int n40 = n17;
                int n41 = n18;
                int n42 = n20;
                int n43 = 0;
                while (n43 < n) {
                    float f5 = fArray3[n41 + n10] * f;
                    float f6 = 1.0f - f5;
                    fArray5[this.aOffset][n42 + nArray3[this.aOffset]] = Float.MAX_VALUE;
                    int n44 = 0;
                    while (n44 < n3) {
                        int n45 = n44 + this.cOffset;
                        fArray5[n45][n42 + nArray3[n45]] = fArray[n44][n39 + nArray[n44]] * f5 + fArray2[n44][n40 + nArray2[n44]] * f6;
                        ++n44;
                    }
                    n39 += n5;
                    n40 += n7;
                    n41 += n9;
                    n42 += n15;
                    ++n43;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n38;
            }
        } else {
            int n46 = 0;
            while (n46 < n2) {
                int n47 = n16;
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = 0;
                while (n52 < n) {
                    float f7;
                    float f8;
                    float f9 = fArray3[n49 + n10];
                    float f10 = (1.0f - f9 * f) * fArray4[n50 + n13];
                    float f11 = f9 + f10;
                    if (f11 == 0.0f) {
                        f8 = 0.0f;
                        f7 = 0.0f;
                    } else {
                        f8 = f9 / f11;
                        f7 = f10 / f11;
                    }
                    fArray5[this.aOffset][n51 + nArray3[this.aOffset]] = f11;
                    int n53 = 0;
                    while (n53 < n3) {
                        int n54 = n53 + this.cOffset;
                        fArray5[n54][n51 + nArray3[n54]] = fArray[n53][n47 + nArray[n53]] * f8 + fArray2[n53][n48 + nArray2[n53]] * f7;
                        ++n53;
                    }
                    n47 += n5;
                    n48 += n7;
                    n49 += n9;
                    n50 += n12;
                    n51 += n15;
                    ++n52;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n46;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int[][] nArray = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray4 = rasterAccessor2.getBandOffsets();
        int[] nArray5 = rasterAccessor3.getIntDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        int[] nArray6 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            nArray6 = rasterAccessor4.getIntDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        int[][] nArray7 = rasterAccessor5.getIntDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray8 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f = 1.0f - (float)nArray5[n24 + n10] * this.invMaxValue;
                        nArray7[this.aOffset][n25 + nArray8[this.aOffset]] = this.maxValue;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            nArray7[n28][n25 + nArray8[n28]] = (int)((float)nArray[n27][n22 + nArray2[n27]] + (float)nArray3[n27][n23 + nArray4[n27]] * f);
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        int n36 = nArray5[n32 + n10];
                        float f = 1.0f - (float)n36 * this.invMaxValue;
                        nArray7[this.aOffset][n34 + nArray8[this.aOffset]] = (int)((float)n36 + (float)nArray6[n33 + n13] * f);
                        int n37 = 0;
                        while (n37 < n3) {
                            int n38 = n37 + this.cOffset;
                            nArray7[n38][n34 + nArray8[n38]] = (int)((float)nArray[n37][n30 + nArray2[n37]] + (float)nArray3[n37][n31 + nArray4[n37]] * f);
                            ++n37;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n2) {
                int n40 = n16;
                int n41 = n17;
                int n42 = n18;
                int n43 = n20;
                int n44 = 0;
                while (n44 < n) {
                    float f = (float)nArray5[n42 + n10] * this.invMaxValue;
                    float f2 = 1.0f - f;
                    nArray7[this.aOffset][n43 + nArray8[this.aOffset]] = this.maxValue;
                    int n45 = 0;
                    while (n45 < n3) {
                        int n46 = n45 + this.cOffset;
                        nArray7[n46][n43 + nArray8[n46]] = (int)((float)nArray[n45][n40 + nArray2[n45]] * f + (float)nArray3[n45][n41 + nArray4[n45]] * f2);
                        ++n45;
                    }
                    n40 += n5;
                    n41 += n7;
                    n42 += n9;
                    n43 += n15;
                    ++n44;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n2) {
                int n48 = n16;
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = 0;
                while (n53 < n) {
                    float f;
                    float f3;
                    int n54 = nArray5[n50 + n10];
                    float f4 = (1.0f - (float)n54 * this.invMaxValue) * (float)nArray6[n51 + n13];
                    float f5 = (float)n54 + f4;
                    if (f5 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = (float)n54 / f5;
                        f = f4 / f5;
                    }
                    nArray7[this.aOffset][n52 + nArray8[this.aOffset]] = (int)f5;
                    int n55 = 0;
                    while (n55 < n3) {
                        int n56 = n55 + this.cOffset;
                        nArray7[n56][n52 + nArray8[n56]] = (int)((float)nArray[n55][n48 + nArray2[n55]] * f3 + (float)nArray3[n55][n49 + nArray4[n55]] * f);
                        ++n55;
                    }
                    n48 += n5;
                    n49 += n7;
                    n50 += n9;
                    n51 += n12;
                    n52 += n15;
                    ++n53;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n47;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        short[] sArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            sArray4 = rasterAccessor4.getShortDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f = 1.0f - (float)sArray3[n24 + n10] * this.invMaxValue;
                        sArray5[this.aOffset][n25 + nArray3[this.aOffset]] = this.maxValueShort;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            sArray5[n28][n25 + nArray3[n28]] = (short)((float)sArray[n27][n22 + nArray[n27]] + (float)sArray2[n27][n23 + nArray2[n27]] * f);
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        short s = sArray3[n32 + n10];
                        float f = 1.0f - (float)s * this.invMaxValue;
                        sArray5[this.aOffset][n34 + nArray3[this.aOffset]] = (short)((float)s + (float)sArray4[n33 + n13] * f);
                        int n36 = 0;
                        while (n36 < n3) {
                            int n37 = n36 + this.cOffset;
                            sArray5[n37][n34 + nArray3[n37]] = (short)((float)sArray[n36][n30 + nArray[n36]] + (float)sArray2[n36][n31 + nArray2[n36]] * f);
                            ++n36;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n38 = 0;
            while (n38 < n2) {
                int n39 = n16;
                int n40 = n17;
                int n41 = n18;
                int n42 = n20;
                int n43 = 0;
                while (n43 < n) {
                    float f = (float)sArray3[n41 + n10] * this.invMaxValue;
                    float f2 = 1.0f - f;
                    sArray5[this.aOffset][n42 + nArray3[this.aOffset]] = this.maxValueShort;
                    int n44 = 0;
                    while (n44 < n3) {
                        int n45 = n44 + this.cOffset;
                        sArray5[n45][n42 + nArray3[n45]] = (short)((float)sArray[n44][n39 + nArray[n44]] * f + (float)sArray2[n44][n40 + nArray2[n44]] * f2);
                        ++n44;
                    }
                    n39 += n5;
                    n40 += n7;
                    n41 += n9;
                    n42 += n15;
                    ++n43;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n38;
            }
        } else {
            int n46 = 0;
            while (n46 < n2) {
                int n47 = n16;
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = 0;
                while (n52 < n) {
                    float f;
                    float f3;
                    short s = sArray3[n49 + n10];
                    float f4 = (1.0f - (float)s * this.invMaxValue) * (float)sArray4[n50 + n13];
                    float f5 = (float)s + f4;
                    if (f5 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = (float)s / f5;
                        f = f4 / f5;
                    }
                    sArray5[this.aOffset][n51 + nArray3[this.aOffset]] = (short)f5;
                    int n53 = 0;
                    while (n53 < n3) {
                        int n54 = n53 + this.cOffset;
                        sArray5[n54][n51 + nArray3[n54]] = (short)((float)sArray[n53][n47 + nArray[n53]] * f3 + (float)sArray2[n53][n48 + nArray2[n53]] * f);
                        ++n53;
                    }
                    n47 += n5;
                    n48 += n7;
                    n49 += n9;
                    n50 += n12;
                    n51 += n15;
                    ++n52;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n46;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        short[] sArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            sArray4 = rasterAccessor4.getShortDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f = 1.0f - (float)(sArray3[n24 + n10] & 0xFFFF) * this.invMaxValue;
                        sArray5[this.aOffset][n25 + nArray3[this.aOffset]] = this.maxValueShort;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            sArray5[n28][n25 + nArray3[n28]] = (short)((float)(sArray[n27][n22 + nArray[n27]] & 0xFFFF) + (float)(sArray2[n27][n23 + nArray2[n27]] & 0xFFFF) * f);
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        int n36 = sArray3[n32 + n10] & 0xFFFF;
                        float f = 1.0f - (float)n36 * this.invMaxValue;
                        sArray5[this.aOffset][n34 + nArray3[this.aOffset]] = (short)((float)n36 + (float)(sArray4[n33 + n13] & 0xFFFF) * f);
                        int n37 = 0;
                        while (n37 < n3) {
                            int n38 = n37 + this.cOffset;
                            sArray5[n38][n34 + nArray3[n38]] = (short)((float)(sArray[n37][n30 + nArray[n37]] & 0xFFFF) + (float)(sArray2[n37][n31 + nArray2[n37]] & 0xFFFF) * f);
                            ++n37;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n2) {
                int n40 = n16;
                int n41 = n17;
                int n42 = n18;
                int n43 = n20;
                int n44 = 0;
                while (n44 < n) {
                    float f = (float)(sArray3[n42 + n10] & 0xFFFF) * this.invMaxValue;
                    float f2 = 1.0f - f;
                    sArray5[this.aOffset][n43 + nArray3[this.aOffset]] = this.maxValueShort;
                    int n45 = 0;
                    while (n45 < n3) {
                        int n46 = n45 + this.cOffset;
                        sArray5[n46][n43 + nArray3[n46]] = (short)((float)(sArray[n45][n40 + nArray[n45]] & 0xFFFF) * f + (float)(sArray2[n45][n41 + nArray2[n45]] & 0xFFFF) * f2);
                        ++n45;
                    }
                    n40 += n5;
                    n41 += n7;
                    n42 += n9;
                    n43 += n15;
                    ++n44;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n2) {
                int n48 = n16;
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = 0;
                while (n53 < n) {
                    float f;
                    float f3;
                    int n54 = sArray3[n50 + n10] & 0xFFFF;
                    float f4 = (1.0f - (float)n54 * this.invMaxValue) * (float)(sArray4[n51 + n13] & 0xFFFF);
                    float f5 = (float)n54 + f4;
                    if (f5 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = (float)n54 / f5;
                        f = f4 / f5;
                    }
                    sArray5[this.aOffset][n52 + nArray3[this.aOffset]] = (short)f5;
                    int n55 = 0;
                    while (n55 < n3) {
                        int n56 = n55 + this.cOffset;
                        sArray5[n56][n52 + nArray3[n56]] = (short)((float)(sArray[n55][n48 + nArray[n55]] & 0xFFFF) * f3 + (float)(sArray2[n55][n49 + nArray2[n55]] & 0xFFFF) * f);
                        ++n55;
                    }
                    n48 += n5;
                    n49 += n7;
                    n50 += n9;
                    n51 += n12;
                    n52 += n15;
                    ++n53;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n47;
            }
        }
    }
}

