/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.CRIFImpl;
import com.sun.media.jai.opimage.PiecewiseOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.TileCache;

public class MatchCDFCRIF
extends CRIFImpl {
    public MatchCDFCRIF() {
        super("matchcdf");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Histogram histogram = (Histogram)renderedImage.getProperty("histogram");
        float[][] fArray = (float[][])parameterBlock.getObjectParameter(0);
        float[][][] fArray2 = MatchCDFCRIF.createSpecificationMap(histogram, fArray);
        return new PiecewiseOpImage(renderedImage, tileCache, imageLayout, fArray2);
    }

    private static void createHistogramMap(float[] fArray, float[] fArray2, double d, double d2, int n, float[] fArray3, float[] fArray4) {
        double d3 = d;
        int n2 = 0;
        int n3 = n - 1;
        int n4 = 0;
        while (n4 < n) {
            float f = fArray[n4];
            while (fArray2[n2] < f && n2 < n3) {
                ++n2;
            }
            fArray3[n4] = (float)d3;
            fArray4[n4] = (float)((double)n2 * d2);
            d3 += d2;
            ++n4;
        }
    }

    private static float[][][] createSpecificationMap(Histogram histogram, float[][] fArray) {
        int n = histogram.getNumBands();
        float[][][] fArray2 = new float[n][][];
        float[] fArray3 = null;
        int n2 = 0;
        while (n2 < n) {
            int n3 = histogram.getNumBins(n2);
            fArray2[n2] = new float[2][];
            fArray2[n2][0] = new float[n3];
            fArray2[n2][1] = new float[n3];
            int[] nArray = histogram.getBins(n2);
            long l = nArray[0];
            int n4 = 1;
            while (n4 < n3) {
                l += (long)nArray[n4];
                ++n4;
            }
            if (fArray3 == null || fArray3.length < n3) {
                fArray3 = new float[n3];
            }
            fArray3[0] = (float)nArray[0] / (float)l;
            int n5 = 1;
            while (n5 < n3) {
                fArray3[n5] = fArray3[n5 - 1] + (float)nArray[n5] / (float)l;
                ++n5;
            }
            double d = (histogram.getHighValue(n2) - histogram.getLowValue(n2)) / (double)n3;
            MatchCDFCRIF.createHistogramMap(fArray3, fArray.length > 1 ? fArray[n2] : fArray[0], histogram.getLowValue(n2), d, n3, fArray2[n2][0], fArray2[n2][1]);
            ++n2;
        }
        return fArray2;
    }
}

