/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class SeparableConvolveOpImage
extends AreaOpImage {
    static int byteLoopCounter = 0;
    protected KernelJAI kernel;
    protected int kw;
    protected int kh;
    protected int kx;
    protected int ky;
    protected float[] hValues;
    protected float[] vValues;
    protected float[][] hTables;

    public SeparableConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, borderExtender, tileCache, imageLayout, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding(), true);
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.hValues = kernelJAI.getHorizontalKernelData();
        this.vValues = kernelJAI.getVerticalKernelData();
        if (this.sampleModel.getDataType() == 0) {
            this.hTables = new float[this.hValues.length][256];
            int n = 0;
            while (n < this.hValues.length) {
                float f = this.hValues[n];
                int n2 = 0;
                while (n2 < 256) {
                    byte by = (byte)n2;
                    float f2 = n2;
                    this.hTables[n][by + 128] = f * f2;
                    ++n2;
                }
                ++n;
            }
        }
    }

    protected void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n];
        int n8 = this.kh * n;
        int n9 = 0;
        while (n9 < n3) {
            int n10;
            int n11;
            int n12;
            int n13;
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n14 = nArray2[n9];
            int n15 = nArray[n9];
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            while (n18 < this.kh - 1) {
                n13 = n14;
                n12 = 0;
                while (n12 < n) {
                    n11 = n13;
                    float f = 0.0f;
                    n10 = 0;
                    while (n10 < this.kw) {
                        f += this.hTables[n10][byArray4[n11] + 128];
                        n11 += n6;
                        ++n10;
                    }
                    fArray[n16 + n12] = f;
                    n13 += n6;
                    ++n12;
                }
                n16 += n;
                n14 += n7;
                ++n18;
            }
            n13 = 0;
            while (n13 < n2) {
                n12 = n14;
                n11 = n15;
                int n19 = 0;
                while (n19 < n) {
                    n10 = n12;
                    float f = 0.0f;
                    int n20 = 0;
                    while (n20 < this.kw) {
                        f += this.hTables[n20][byArray4[n10] + 128];
                        n10 += n6;
                        ++n20;
                    }
                    fArray[n16 + n19] = f;
                    f = 0.5f;
                    int n21 = n17 + n19;
                    int n22 = 0;
                    while (n22 < this.kh) {
                        f += fArray[n21] * this.vValues[n22];
                        if ((n21 += n) >= n8) {
                            n21 -= n8;
                        }
                        ++n22;
                    }
                    int n23 = (int)f;
                    if (n23 < 0) {
                        n23 = 0;
                    } else if (n23 > 255) {
                        n23 = 255;
                    }
                    byArray3[n11] = (byte)n23;
                    n12 += n6;
                    n11 += n4;
                    ++n19;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                if ((n17 += n) == n8) {
                    n17 = 0;
                }
                n14 += n7;
                n15 += n5;
                ++n13;
            }
            ++n9;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    protected void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        double[] dArray3 = new double[this.kh * n];
        int n8 = this.kh * n;
        int n9 = 0;
        while (n9 < n3) {
            int n10;
            int n11;
            int n12;
            double[] dArray4 = dArray[n9];
            double[] dArray5 = dArray2[n9];
            int n13 = nArray2[n9];
            int n14 = nArray[n9];
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            while (n17 < this.kh - 1) {
                n12 = n13;
                n11 = 0;
                while (n11 < n) {
                    n10 = n12;
                    double d = 0.0;
                    int n18 = 0;
                    while (n18 < this.kw) {
                        d += dArray5[n10] * (double)this.hValues[n18];
                        n10 += n6;
                        ++n18;
                    }
                    dArray3[n15 + n11] = d;
                    n12 += n6;
                    ++n11;
                }
                n15 += n;
                n13 += n7;
                ++n17;
            }
            n12 = 0;
            while (n12 < n2) {
                n11 = n13;
                n10 = n14;
                int n19 = 0;
                while (n19 < n) {
                    int n20 = n11;
                    double d = 0.0;
                    int n21 = 0;
                    while (n21 < this.kw) {
                        d += dArray5[n20] * (double)this.hValues[n21];
                        n20 += n6;
                        ++n21;
                    }
                    dArray3[n15 + n19] = d;
                    d = 0.0;
                    int n22 = n16 + n19;
                    int n23 = 0;
                    while (n23 < this.kh) {
                        d += dArray3[n22] * (double)this.vValues[n23];
                        if ((n22 += n) >= n8) {
                            n22 -= n8;
                        }
                        ++n23;
                    }
                    dArray4[n10] = d;
                    n11 += n6;
                    n10 += n4;
                    ++n19;
                }
                if ((n15 += n) == n8) {
                    n15 = 0;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                n13 += n7;
                n14 += n5;
                ++n12;
            }
            ++n9;
        }
    }

    protected void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray3 = new float[this.kh * n];
        int n8 = this.kh * n;
        int n9 = 0;
        while (n9 < n3) {
            int n10;
            int n11;
            int n12;
            int n13;
            float[] fArray4 = fArray[n9];
            float[] fArray5 = fArray2[n9];
            int n14 = nArray2[n9];
            int n15 = nArray[n9];
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            while (n18 < this.kh - 1) {
                n13 = n14;
                n12 = 0;
                while (n12 < n) {
                    n11 = n13;
                    float f = 0.0f;
                    n10 = 0;
                    while (n10 < this.kw) {
                        f += fArray5[n11] * this.hValues[n10];
                        n11 += n6;
                        ++n10;
                    }
                    fArray3[n16 + n12] = f;
                    n13 += n6;
                    ++n12;
                }
                n16 += n;
                n14 += n7;
                ++n18;
            }
            n13 = 0;
            while (n13 < n2) {
                n12 = n14;
                n11 = n15;
                int n19 = 0;
                while (n19 < n) {
                    n10 = n12;
                    float f = 0.0f;
                    int n20 = 0;
                    while (n20 < this.kw) {
                        f += fArray5[n10] * this.hValues[n20];
                        n10 += n6;
                        ++n20;
                    }
                    fArray3[n16 + n19] = f;
                    f = 0.0f;
                    int n21 = n17 + n19;
                    int n22 = 0;
                    while (n22 < this.kh) {
                        f += fArray3[n21] * this.vValues[n22];
                        if ((n21 += n) >= n8) {
                            n21 -= n8;
                        }
                        ++n22;
                    }
                    fArray4[n11] = f;
                    n12 += n6;
                    n11 += n4;
                    ++n19;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                if ((n17 += n) == n8) {
                    n17 = 0;
                }
                n14 += n7;
                n15 += n5;
                ++n13;
            }
            ++n9;
        }
    }

    protected void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n];
        int n8 = this.kh * n;
        int n9 = 0;
        while (n9 < n3) {
            int n10;
            int n11;
            int n12;
            int n13;
            int[] nArray5 = nArray[n9];
            int[] nArray6 = nArray3[n9];
            int n14 = nArray4[n9];
            int n15 = nArray2[n9];
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            while (n18 < this.kh - 1) {
                n13 = n14;
                n12 = 0;
                while (n12 < n) {
                    n11 = n13;
                    float f = 0.0f;
                    n10 = 0;
                    while (n10 < this.kw) {
                        f += (float)nArray6[n11] * this.hValues[n10];
                        n11 += n6;
                        ++n10;
                    }
                    fArray[n16 + n12] = f;
                    n13 += n6;
                    ++n12;
                }
                n16 += n;
                n14 += n7;
                ++n18;
            }
            n13 = 0;
            while (n13 < n2) {
                n12 = n14;
                n11 = n15;
                int n19 = 0;
                while (n19 < n) {
                    int n20;
                    n10 = n12;
                    float f = 0.0f;
                    int n21 = 0;
                    while (n21 < this.kw) {
                        f += (float)nArray6[n10] * this.hValues[n21];
                        n10 += n6;
                        ++n21;
                    }
                    fArray[n16 + n19] = f;
                    f = 0.5f;
                    int n22 = n17 + n19;
                    int n23 = 0;
                    while (n23 < this.kh) {
                        f += fArray[n22] * this.vValues[n23];
                        if ((n22 += n) >= n8) {
                            n22 -= n8;
                        }
                        ++n23;
                    }
                    nArray5[n11] = n20 = (int)f;
                    n12 += n6;
                    n11 += n4;
                    ++n19;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                if ((n17 += n) == n8) {
                    n17 = 0;
                }
                n14 += n7;
                n15 += n5;
                ++n13;
            }
            ++n9;
        }
    }

    protected void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n];
        int n8 = this.kh * n;
        int n9 = 0;
        while (n9 < n3) {
            int n10;
            int n11;
            int n12;
            int n13;
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n14 = nArray2[n9];
            int n15 = nArray[n9];
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            while (n18 < this.kh - 1) {
                n13 = n14;
                n12 = 0;
                while (n12 < n) {
                    n11 = n13;
                    float f = 0.0f;
                    n10 = 0;
                    while (n10 < this.kw) {
                        f += (float)sArray4[n11] * this.hValues[n10];
                        n11 += n6;
                        ++n10;
                    }
                    fArray[n16 + n12] = f;
                    n13 += n6;
                    ++n12;
                }
                n16 += n;
                n14 += n7;
                ++n18;
            }
            n13 = 0;
            while (n13 < n2) {
                n12 = n14;
                n11 = n15;
                int n19 = 0;
                while (n19 < n) {
                    n10 = n12;
                    float f = 0.0f;
                    int n20 = 0;
                    while (n20 < this.kw) {
                        f += (float)sArray4[n10] * this.hValues[n20];
                        n10 += n6;
                        ++n20;
                    }
                    fArray[n16 + n19] = f;
                    f = 0.5f;
                    int n21 = n17 + n19;
                    int n22 = 0;
                    while (n22 < this.kh) {
                        f += fArray[n21] * this.vValues[n22];
                        if ((n21 += n) >= n8) {
                            n21 -= n8;
                        }
                        ++n22;
                    }
                    int n23 = (int)f;
                    if (n23 < Short.MIN_VALUE) {
                        n23 = Short.MIN_VALUE;
                    } else if (n23 > Short.MAX_VALUE) {
                        n23 = Short.MAX_VALUE;
                    }
                    sArray3[n11] = (short)n23;
                    n12 += n6;
                    n11 += n4;
                    ++n19;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                if ((n17 += n) == n8) {
                    n17 = 0;
                }
                n14 += n7;
                n15 += n5;
                ++n13;
            }
            ++n9;
        }
    }

    protected void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n];
        int n8 = this.kh * n;
        int n9 = 0;
        while (n9 < n3) {
            int n10;
            int n11;
            int n12;
            int n13;
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n14 = nArray2[n9];
            int n15 = nArray[n9];
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            while (n18 < this.kh - 1) {
                n13 = n14;
                n12 = 0;
                while (n12 < n) {
                    n11 = n13;
                    float f = 0.0f;
                    n10 = 0;
                    while (n10 < this.kw) {
                        f += (float)(sArray4[n11] & 0xFFFF) * this.hValues[n10];
                        n11 += n6;
                        ++n10;
                    }
                    fArray[n16 + n12] = f;
                    n13 += n6;
                    ++n12;
                }
                n16 += n;
                n14 += n7;
                ++n18;
            }
            n13 = 0;
            while (n13 < n2) {
                n12 = n14;
                n11 = n15;
                int n19 = 0;
                while (n19 < n) {
                    n10 = n12;
                    float f = 0.0f;
                    int n20 = 0;
                    while (n20 < this.kw) {
                        f += (float)(sArray4[n10] & 0xFFFF) * this.hValues[n20];
                        n10 += n6;
                        ++n20;
                    }
                    fArray[n16 + n19] = f;
                    f = 0.5f;
                    int n21 = n17 + n19;
                    int n22 = 0;
                    while (n22 < this.kh) {
                        f += fArray[n21] * this.vValues[n22];
                        if ((n21 += n) >= n8) {
                            n21 -= n8;
                        }
                        ++n22;
                    }
                    int n23 = (int)f;
                    if (n23 < 0) {
                        n23 = 0;
                    } else if (n23 > 65535) {
                        n23 = 65535;
                    }
                    sArray3[n11] = (short)n23;
                    n12 += n6;
                    n11 += n4;
                    ++n19;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                if ((n17 += n) == n8) {
                    n17 = 0;
                }
                n14 += n7;
                n15 += n5;
                ++n13;
            }
            ++n9;
        }
    }
}

